/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubCreditsToDeveloper {
    private static final Logger LOG = LoggerFactory.getLogger(SubCreditsToDeveloper.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private CustomService customService;

    public void submit(CreditsMessage req, final String msgTopic, final String msgTag, final String msgKey) {
        HttpPost http;
        final CreditsMessage request = this.customService.getRequestCredits(req);
        if ("post".equals(request.getHttpType())) {
            http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
            HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [http_method post] [url " + request.getHttpUrl() + "] [authParams " + request.getAuthParams() + "]");
        } else {
            http = new HttpGet(request.getHttpUrl());
            HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [http_method get] [url " + request.getHttpUrl() + "]");
        }
        this.httpAsyncClientPool.submit(request.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("completed");
                    String body = SubCreditsToDeveloper.this.customService.getResponseCredits(request.getAppId(), EntityUtils.toString((HttpEntity)response.getEntity()));
                    resp.setMessage(HttpRequestLog.subBody(body));
                }
                catch (Exception e) {
                    LOG.error("toDeveloper completed", (Throwable)e);
                }
                finally {
                    SubCreditsToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, response.getStatusLine().getStatusCode() + "");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                LOG.error("toDeveloper failed bizId:" + request.getRelationId() + " bizType:" + request.getRelationType(), (Throwable)ex);
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    LOG.error("toDeveloper failed", (Throwable)e);
                }
                finally {
                    SubCreditsToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
                }
            }

            public void cancelled() {
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage("http cancelled");
                }
                catch (Exception e) {
                    LOG.error("toDeveloper cancelled", (Throwable)e);
                }
                finally {
                    SubCreditsToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finallyBlock(CreditsMessage req, CreditsCallbackMessage resp, String msgTopic, String msgTag, String msgKey, String code) {
        try {
            resp.setRelationId(req.getRelationId());
            resp.setRelationType(req.getRelationType());
            resp.setParams(req.getParams());
            resp.setAppId(req.getAppId());
            resp.setConsumerId(req.getConsumerId());
            resp.setHttpUrl(req.getHttpUrl());
            String body = JsonTool.objectToJson(resp);
            if (StringUtils.isEmpty((String)msgTag) && StringUtils.isEmpty((String)msgKey)) {
                this.messageService.sendMsg(msgTopic, body);
            } else {
                this.messageService.sendMsg(msgTopic, msgTag, msgKey, body);
            }
        }
        catch (Exception e) {
            LOG.error("credits callback: bizId:" + req.getRelationId() + " bizType:" + req.getRelationType(), (Throwable)e);
        }
        finally {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [code " + code + "] [bizId " + req.getRelationId() + "] [type " + req.getRelationType() + "] [callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
        }
    }
}

