/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.phonebill.supplier;

import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LianLianPhonebillSupplier {
    private static Logger log = LoggerFactory.getLogger(LianLianPhonebillSupplier.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    public void asyncSubmit(final SupplierRequest message, final String callbackTopic, final String msgTag, final String msgKey) {
        if (!this.messageService.messageUniqueCheck(message.getSupplierOrderId(), "phonebill")) {
            return;
        }
        HttpGet get = new HttpGet(message.getHttpUrl());
        HttpRequestLog.logUrl("[action phonebill] [tag request] [bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "]");
        this.httpAsyncClientPool.submit(message.getAppId(), (HttpUriRequest)get, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setSupplierName(message.getSupplierName());
                    resp.setUrl(message.getHttpUrl());
                    resp.setCallbackType("completed");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    resp.setBody(body);
                }
                catch (Exception e) {
                    log.error("LianLianPhonebillSupplier completed", (Throwable)e);
                }
                finally {
                    LianLianPhonebillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                log.error("LianLianPhonebillSupplier failed orderId:" + message.getOrderId(), (Throwable)ex);
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setCallbackType("failed");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                    resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    log.error("LianLianPhonebillSupplier completed", (Throwable)e);
                }
                finally {
                    LianLianPhonebillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            public void cancelled() {
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setCallbackType("cancelled");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                }
                catch (Exception e) {
                    log.error("LianLianPhonebillSupplier cancelled", (Throwable)e);
                }
                finally {
                    LianLianPhonebillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }
        });
    }

    private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey) {
        try {
            response.setUrl(message.getHttpUrl());
            response.setSupplierName(message.getSupplierName());
            response.setSupplierOrderId(message.getSupplierOrderId());
            response.setOrderId(message.getOrderId());
            response.setAppId(message.getAppId());
            response.setConsumerId(message.getConsumerId());
            String body = JsonTool.objectToJson(response);
            HttpRequestLog.logUrl("[action phonebill] [tag response] [callback " + response.getCallbackType() + "] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "]");
            if (StringUtils.isEmpty((String)msgTag) && StringUtils.isEmpty((String)msgKey)) {
                this.messageService.sendMsg(callbackTopic, body);
            } else {
                this.messageService.sendMsg(callbackTopic, msgTag, msgKey, body);
            }
        }
        catch (Exception e) {
            log.error("LianLianPhonebillSupplier callback:" + message.getOrderId(), (Throwable)e);
        }
    }
}

