/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.crecord.message;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;
import cn.com.duiba.service.HttpRetryRulesService;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.thirdparty.dto.HttpResponseMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrecordAsyncHttp {
    private static Logger log = LoggerFactory.getLogger(CrecordAsyncHttp.class);
    @Autowired
    private HttpRetryRulesService httpRetryRulesService;
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private ThreadPoolService threadPoolService;
    @Autowired
    private NotifyHttpClientPool notifyHttpClientPool;

    public void asyncSubmit(String message) {
        HttpRequestMessageDto dto = (HttpRequestMessageDto)JSONObject.parseObject((String)message, HttpRequestMessageDto.class);
        AppDO app = this.appDAO.findAppSimple(dto.getAppId());
        if (app == null || StringUtils.isEmpty((String)app.getRecordNotifyUrl())) {
            log.warn("appId:" + dto.getAppId() + " recordNotifyUrl: is empty");
            return;
        }
        HttpMessageDO hmd = new HttpMessageDO();
        hmd.setAppId(dto.getAppId());
        hmd.setBizType(dto.getBizType());
        hmd.setBizParams(JSONObject.toJSONString((Object)dto.getHttpParams()));
        hmd.setNumber(0);
        hmd.setOffset(this.httpRetryRulesService.getNextSecond(hmd));
        this.httpMessageDAO.insert(hmd);
        this.asyncSubmit(hmd, dto, app);
    }

    public void asyncSubmit(final HttpMessageDO db, final HttpRequestMessageDto msg, AppDO app) {
        Map map = msg.getHttpParams();
        map.put("appKey", app.getAppKey());
        map.put("appSecret", this.appDAO.getAppSecret(app));
        String sign = SignTool.sign((Map)map);
        map.put("sign", sign);
        map.remove("appSecret");
        final String url = AssembleTool.assembleUrl(app.getRecordNotifyUrl(), map);
        HttpGet get = new HttpGet(url);
        HttpRequestLog.logUrl("[action crecord] [tag request] [url " + url + "]");
        this.notifyHttpClientPool.submit(msg.getAppId(), (HttpUriRequest)get, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                try {
                    String cont;
                    resp.setCallbackType("completed");
                    resp.setHttpUrl(url);
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (StringUtils.isNotEmpty((String)body) && (cont = body.toLowerCase()).contains("ok")) {
                        resp.setSuccess(Boolean.valueOf(true));
                    }
                    resp.setBody(HttpRequestLog.subBody(body));
                    resp.setBizId(msg.getBizId());
                    resp.setBizType(msg.getBizType());
                }
                catch (Exception e) {
                    resp.setSuccess(Boolean.valueOf(false));
                    resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:completed:" + e.getMessage());
                    log.error("completed", (Throwable)e);
                }
                finally {
                    CrecordAsyncHttp.this.httpRequestComleted(db, resp);
                }
            }

            public void failed(Exception ex) {
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                resp.setCallbackType("failed");
                resp.setHttpUrl(url);
                resp.setBizId(msg.getBizId());
                resp.setBizType(msg.getBizType());
                resp.setSuccess(Boolean.valueOf(false));
                resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:failed:" + ex.getMessage());
                CrecordAsyncHttp.this.httpRequestComleted(db, resp);
            }

            public void cancelled() {
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                resp.setCallbackType("cancelled");
                resp.setHttpUrl(url);
                resp.setBizId(msg.getBizId());
                resp.setBizType(msg.getBizType());
                resp.setSuccess(Boolean.valueOf(false));
                resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:cancelled");
                CrecordAsyncHttp.this.httpRequestComleted(db, resp);
            }
        });
    }

    private void httpRequestComleted(final HttpMessageDO db, final HttpResponseMessageDto resp) {
        HttpRequestLog.logUrl("[action crecord] [tag Response] [callback " + resp.getCallbackType() + "] [body " + resp.getBody() + "]");
        this.threadPoolService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!"completed".equals(resp.getCallbackType()) || !"ok".equals(resp.getBody().toLowerCase())) {
                        if (db.getNumber() >= CrecordAsyncHttp.this.httpRetryRulesService.getRetryNumber(db)) {
                            CrecordAsyncHttp.this.httpMessageDAO.delete(db.getId());
                            return;
                        }
                        CrecordAsyncHttp.this.httpMessageDAO.updateNextTime(db.getId(), CrecordAsyncHttp.this.httpRetryRulesService.getNextSecond(db));
                        return;
                    }
                    CrecordAsyncHttp.this.httpMessageDAO.delete(db.getId());
                }
                catch (Exception e) {
                    log.error("httpRequestComleted", (Throwable)e);
                }
            }
        });
    }
}

