/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.crecord.service;

import cn.com.duiba.crecord.message.CrecordAsyncHttp;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CrecordHttpRetryJob
extends AbstractSimpleElasticJob {
    private Logger log = LoggerFactory.getLogger(CrecordHttpRetryJob.class);
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private CrecordAsyncHttp toDeveloper;
    @Autowired
    private AppDAO appDAO;
    @Value(value="${notifycenter.timer.enable}")
    private boolean timerEnable;

    public void process(JobExecutionMultipleShardingContext shardingContext) {
        try {
            AppDO app;
            if (!this.timerEnable) {
                return;
            }
            Date start = new Date();
            List<HttpMessageDO> dos = this.httpMessageDAO.findNeedRetry("crecord", 5000);
            HashMap<Long, AppDO> appMap = new HashMap<Long, AppDO>();
            HashSet<Long> appIds = new HashSet<Long>();
            for (HttpMessageDO db : dos) {
                appIds.add(db.getAppId());
            }
            for (Long appId : appIds) {
                app = this.appDAO.findAppSimple(appId);
                appMap.put(appId, app);
            }
            for (HttpMessageDO db : dos) {
                app = (AppDO)appMap.get(db.getAppId());
                HttpRequestMessageDto dto = new HttpRequestMessageDto();
                dto.setAppId(db.getAppId());
                dto.setBizType(db.getBizType());
                Map httpParams = (Map)JSONObject.parseObject((String)db.getBizParams(), Map.class);
                dto.setHttpParams(httpParams);
                this.toDeveloper.asyncSubmit(db, dto, app);
            }
            Date end = new Date();
            this.log.info("crecord scan size:" + dos.size() + " time:" + (end.getTime() - start.getTime()) + "ms");
        }
        catch (Exception e) {
            this.log.error("CrecordHttpRetryJob error:", (Throwable)e);
        }
    }
}

