/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.notifycenter.service;

import cn.com.duiba.service.ThreadPoolService;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotifyHttpClientPool
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NotifyHttpClientPool.class);
    public static final int CONNECT_TIMEOUT = 30000;
    public static final int KEEPALIVE_TIMEOUT = 30000;
    public static final int SOCKET_TIMEOUT = 30000;
    public static final int MAX_CONNECT = 1024;
    public static final int MAX_ROUTE_CONNECT = 128;
    private CloseableHttpAsyncClient httpClient;
    private Map<Long, AtomicInteger> runningStat = new ConcurrentHashMap<Long, AtomicInteger>();
    @Autowired
    private ThreadPoolService threadPoolService;

    public void execute(Long appId, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        try {
            long s = System.currentTimeMillis();
            AtomicInteger count = this.runningStat.get(appId);
            if (count == null) {
                count = new AtomicInteger(1);
                this.runningStat.put(appId, count);
            } else {
                count.incrementAndGet();
            }
            request.setHeader("User-Agent", "Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1");
            CallbackProcesser process = new CallbackProcesser(appId, request, callback);
            if (!this.httpClient.isRunning()) {
                this.start();
            }
            this.httpClient.execute(process.getRequest(), (FutureCallback)process);
            long e = System.currentTimeMillis();
            long t = e - s;
            if (t > 1000L) {
                log.warn("notify httpClent.execute > " + t + "ms");
            }
        }
        catch (Exception e) {
            callback.failed(e);
            log.error("execute:", (Throwable)e);
        }
    }

    public void submit(final Long appId, final HttpUriRequest request, final FutureCallback<HttpResponse> callback) {
        if (this.threadPoolService.canSubmit()) {
            this.threadPoolService.submit(new Runnable(){

                @Override
                public void run() {
                    NotifyHttpClientPool.this.execute(appId, request, (FutureCallback<HttpResponse>)callback);
                }
            });
        } else {
            this.execute(appId, request, callback);
        }
    }

    public JSONObject dumpDetail() {
        HashMap<Long, AtomicInteger> map = new HashMap<Long, AtomicInteger>();
        for (Map.Entry<Long, AtomicInteger> entry : this.runningStat.entrySet()) {
            if (entry.getValue().intValue() <= 0) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        JSONObject o = new JSONObject();
        o.put("runningStat", map);
        return o;
    }

    public int dumpSize() {
        int total = 0;
        for (AtomicInteger a : this.runningStat.values()) {
            total += a.get();
        }
        return total;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        if (this.httpClient != null && this.httpClient.isRunning()) {
            this.httpClient.close();
            log.info("Notify httpClient closed");
        }
    }

    private synchronized void start() {
        if (this.httpClient != null && this.httpClient.isRunning()) {
            return;
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
        this.httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(1024).setMaxConnPerRoute(128).setKeepAliveStrategy((ConnectionKeepAliveStrategy)this.getKeepAliveStrategy()).build();
        this.httpClient.start();
        log.info("Notify httpClient started");
    }

    private DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1L) {
                    return 30000L;
                }
                return duration;
            }
        };
    }

    class CallbackProcesser
    implements FutureCallback<HttpResponse> {
        private HttpUriRequest request;
        private FutureCallback<HttpResponse> callback;
        private Long appId;

        public CallbackProcesser(Long appId, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
            this.request = request;
            this.callback = callback;
            this.appId = appId;
        }

        public void completed(HttpResponse result) {
            try {
                this.callback.completed((Object)result);
            }
            finally {
                ((AtomicInteger)NotifyHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        public void failed(Exception ex) {
            try {
                this.callback.failed(ex);
            }
            finally {
                ((AtomicInteger)NotifyHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        public void cancelled() {
            try {
                this.callback.cancelled();
            }
            finally {
                ((AtomicInteger)NotifyHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        public HttpUriRequest getRequest() {
            return this.request;
        }
    }
}

