/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.notifycenter.service.impl;

import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.BussinessTypesService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.tool.Environment;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bussinessTypesService")
public class BusinessTypeServiceImpl
implements BussinessTypesService {
    private static Logger log = LoggerFactory.getLogger(BusinessTypeServiceImpl.class);
    @Autowired
    private Environment environment;
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private CustomService customService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpUriRequest getRequest(NotifyQueueDO record) {
        try {
            HttpGet request;
            String uid;
            DBTimeProfile.enter((String)"getRequest");
            AppDO app = this.appDAO.getAppByCache(record.getAppId());
            if (app.getCreditsConsumeNotifyUrl() == null || app.getCreditsConsumeNotifyUrl().length() == 0) {
                HttpUriRequest httpUriRequest = null;
                return httpUriRequest;
            }
            String errorMessage = "";
            if (record.getError4developer() != null) {
                errorMessage = record.getError4developer();
            }
            if ((uid = record.getPartnerUserId()) == null) {
                uid = "";
            }
            String bizId = "";
            if (record.getDeveloperBizId() != null) {
                bizId = record.getDeveloperBizId();
            }
            CreditNotifyParams p = new CreditNotifyParams();
            p.setSuccess(record.getResult().booleanValue());
            p.setErrorMessage(errorMessage);
            p.setAppKey(app.getAppKey());
            p.setBizId(bizId);
            p.setUid(uid);
            p.setOrderNum(record.getDuibaOrderNum());
            String customApiUrl = this.customService.getRequestNotify(app.getCreditsConsumeNotifyUrl(), record);
            if (StringUtils.isNotEmpty((String)customApiUrl)) {
                HttpGet request2 = new HttpGet(customApiUrl);
                request2.setConfig(this.getDefaultConfig());
                HttpGet httpGet = request2;
                return httpGet;
            }
            Map<String, String> map = Collections.emptyMap();
            map = this.customService.isNotifyWithTransfer(record.getAppId()) ? this.customService.toRequestMapWithTransfer(this.appDAO.getAppSecret(app), p, record.getTransfer(), uid) : p.toRequestMap(this.appDAO.getAppSecret(app));
            String url = BusinessTypeServiceImpl.assembleUrl(app.getCreditsConsumeNotifyUrl(), map);
            if ("baiduyun".equals(this.environment.getPlace())) {
                request = this.assembleRequest(app.getCreditsConsumeNotifyUrl(), map);
                request.setConfig(this.getDefaultConfig());
            } else {
                request = new HttpGet(url);
                request.setConfig(this.getDefaultConfig());
            }
            HttpGet httpGet = request;
            return httpGet;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private RequestConfig getDefaultConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }

    public HttpPost assembleRequest(String url, Map<String, String> params) {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair(entry.getKey(), value));
        }
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName("utf-8")));
        return post;
    }

    public static String assembleUrl(String urlPar, Map<String, String> params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (str.toString().contains("?")) {
            str.append("&");
        } else {
            str.append("?");
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().length() == 0) {
                    str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "utf-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                log.error("assembleUrl", (Throwable)e);
            }
        }
        return str.toString();
    }
}

