/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.notifycenter.service.impl;

import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.BussinessTypesService;
import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSON;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="notifyService")
public class NotifyServiceImpl
extends AbstractSimpleElasticJob
implements NotifyService {
    private static Logger log = LoggerFactory.getLogger(NotifyServiceImpl.class);
    @Autowired
    private NotifyHttpClientPool notifyHttpClientPool;
    @Autowired
    private NotifyQueueDAO notifyQueueDAO;
    @Autowired
    private BussinessTypesService bussinessTypesService;
    @Autowired
    private CustomService customService;
    @Value(value="${notifycenter.timer.enable}")
    private boolean timerEnable;

    public void process(JobExecutionMultipleShardingContext shardingContext) {
        this.scan();
    }

    @Override
    public void scan() {
        if (!this.timerEnable) {
            return;
        }
        long start = System.currentTimeMillis();
        List<NotifyQueueDO> list = this.notifyQueueDAO.findNeedNotifyList();
        for (NotifyQueueDO queue : list) {
            this.notify(queue);
        }
        long end = System.currentTimeMillis();
        log.info("notify scan size:" + list.size() + " time:" + (end - start) + "ms");
    }

    @Override
    public void notify(NotifyQueueDO queue) {
        try {
            NotifyFutureCallback callback = new NotifyFutureCallback(queue);
            HttpUriRequest request = this.bussinessTypesService.getRequest(queue);
            if (request != null) {
                HttpRequestLog.logUrl("[action notify] [tag request] [bizId " + queue.getDuibaOrderNum() + "] [url " + request.getURI().toString() + "]");
                this.notifyHttpClientPool.submit(queue.getAppId(), request, callback);
            } else {
                log.warn("notifyQueueId=" + queue.getId() + ", can't gen notify url,delete. " + JSON.toJSONString((Object)queue));
                this.notifyQueueDAO.finish(queue.getId());
            }
        }
        catch (Exception e) {
            this.notifyQueueDAO.finish(queue.getId());
            log.error("notifyQueueId=" + queue.getId() + ",submit error:" + JSON.toJSONString((Object)queue), (Throwable)e);
        }
    }

    @Override
    public Date getNextTime(NotifyQueueDO notifyQueue) {
        HashMap<Integer, Long> timeMap = new HashMap<Integer, Long>();
        timeMap.put(0, 120000L);
        timeMap.put(1, 600000L);
        timeMap.put(2, 600000L);
        timeMap.put(3, 3600000L);
        timeMap.put(4, 0x6DDD00L);
        timeMap.put(5, 21600000L);
        timeMap.put(6, 54000000L);
        return new Date(System.currentTimeMillis() + (Long)timeMap.get(notifyQueue.getTimes()));
    }

    class NotifyFutureCallback
    implements FutureCallback<HttpResponse> {
        private NotifyQueueDO notifyQueue;

        public NotifyFutureCallback(NotifyQueueDO notifyQueue) {
            this.notifyQueue = notifyQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(HttpResponse response) {
            String body = null;
            try {
                String entity = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                body = NotifyServiceImpl.this.customService.getResponseNotify(this.notifyQueue.getAppId(), entity);
                if (body != null) {
                    body = body.trim();
                }
                if ("ok".equalsIgnoreCase(body)) {
                    this.success();
                } else {
                    this.fail();
                }
            }
            catch (Exception e) {
                log.error("completed", (Throwable)e);
                this.fail();
            }
            finally {
                HttpRequestLog.logUrl("[action notify] [tag response] [bizId " + this.notifyQueue.getDuibaOrderNum() + "] [type completed] [body " + body + "]");
            }
        }

        public void failed(Exception ex) {
            HttpRequestLog.logUrl("[action notify] [tag response] [bizId " + this.notifyQueue.getDuibaOrderNum() + "] [type failed] [ex " + ex.getMessage() + "]");
            this.fail();
        }

        public void cancelled() {
            HttpRequestLog.logUrl("[action notify] [tag response] [type cancelled] [bizId " + this.notifyQueue.getDuibaOrderNum() + "]");
            this.fail();
        }

        private void success() {
            NotifyServiceImpl.this.notifyQueueDAO.finish(this.notifyQueue.getId());
        }

        private void fail() {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(5, -1);
            if (this.notifyQueue.getTimes() > 6) {
                NotifyServiceImpl.this.notifyQueueDAO.finish(this.notifyQueue.getId());
                log.warn("relationType=" + this.notifyQueue.getRelationType() + ",relationId=" + this.notifyQueue.getRelationId() + " notify:" + this.notifyQueue.getTimes() + " fail,drop");
            } else if (this.notifyQueue.getTimes() > 1 && this.notifyQueue.getGmtCreate().before(cal.getTime())) {
                NotifyServiceImpl.this.notifyQueueDAO.finish(this.notifyQueue.getId());
                log.warn("relationType=" + this.notifyQueue.getRelationType() + ",relationId=" + this.notifyQueue.getRelationId() + " notify > 24h,drop");
            } else {
                Date nexttime = NotifyServiceImpl.this.getNextTime(this.notifyQueue);
                NotifyServiceImpl.this.notifyQueueDAO.updateNextTime(this.notifyQueue.getId(), this.notifyQueue.getTimes() + 1, nexttime);
            }
        }
    }
}

