/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service;

import cn.com.duiba.service.ThreadPoolService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpAsyncClientPool
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HttpAsyncClientPool.class);
    public static final int CONNECT_TIMEOUT = 30000;
    public static final int KEEPALIVE_TIMEOUT = 30000;
    public static final int SOCKET_TIMEOUT = 30000;
    public static final int MAX_CONNECT = 5000;
    public static final int MAX_ROUTE_CONNECT = 200;
    public static final int MAX_APP_QUEUE = 200;
    private CloseableHttpAsyncClient httpClient;
    private Map<String, AtomicInteger> runningStat = new ConcurrentHashMap<String, AtomicInteger>();
    @Autowired
    private ThreadPoolService threadPoolService;

    public void execute(String queueKey, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        try {
            long s = System.currentTimeMillis();
            AtomicInteger running = this.runningStat.get(queueKey);
            if (running == null) {
                this.runningStat.put(queueKey, new AtomicInteger(1));
            } else {
                running.incrementAndGet();
            }
            if (!this.httpClient.isRunning()) {
                this.start();
            }
            request.setHeader("User-Agent", "Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1");
            this.httpClient.execute(request, (FutureCallback)new CallbackProcesser(queueKey, callback));
            long e = System.currentTimeMillis();
            long t = e - s;
            if (t > 1000L) {
                log.warn("http get pool time > " + t + "ms");
            }
        }
        catch (Exception e) {
            callback.failed(e);
            log.error("execute:", (Throwable)e);
        }
    }

    public void submit(final String queueKey, final HttpUriRequest request, final FutureCallback<HttpResponse> callback) {
        if (this.threadPoolService.canSubmit()) {
            this.threadPoolService.submit(new Runnable(){

                @Override
                public void run() {
                    HttpAsyncClientPool.this.execute(queueKey, request, (FutureCallback<HttpResponse>)callback);
                }
            });
        } else {
            this.execute(queueKey, request, callback);
        }
    }

    public boolean canSubmitToAppPool(String queueKey) {
        int queueCount = 0;
        AtomicInteger running = this.runningStat.get(queueKey);
        if (running != null) {
            queueCount = running.intValue();
        }
        return queueCount < 200;
    }

    public Map<String, Object> dumpDetail() {
        HashMap<String, AtomicInteger> map = new HashMap<String, AtomicInteger>();
        for (Map.Entry<String, AtomicInteger> entry : this.runningStat.entrySet()) {
            if (entry.getValue().intValue() <= 0) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("runningStat", map);
        return ret;
    }

    public int dumpSize() {
        int running = 0;
        for (AtomicInteger a : this.runningStat.values()) {
            running += a.get();
        }
        return running;
    }

    public void destroy() throws Exception {
        if (this.httpClient != null && this.httpClient.isRunning()) {
            this.httpClient.close();
            log.info("HttpAsyncClientPool closed");
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    private synchronized void start() {
        if (this.httpClient != null && this.httpClient.isRunning()) {
            return;
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
        this.httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(5000).setMaxConnPerRoute(200).setKeepAliveStrategy((ConnectionKeepAliveStrategy)this.getKeepAliveStrategy()).build();
        this.httpClient.start();
        log.info("HttpAsyncClientPool started");
    }

    private DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1L) {
                    return 30000L;
                }
                return duration;
            }
        };
    }

    private class CallbackProcesser
    implements FutureCallback<HttpResponse> {
        private FutureCallback<HttpResponse> callback;
        private String queueKey;

        public CallbackProcesser(String queueKey, FutureCallback<HttpResponse> callback) {
            this.callback = callback;
            this.queueKey = queueKey;
        }

        public void completed(HttpResponse result) {
            try {
                this.callback.completed((Object)result);
            }
            finally {
                ((AtomicInteger)HttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }

        public void failed(Exception ex) {
            try {
                this.callback.failed(ex);
            }
            finally {
                ((AtomicInteger)HttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }

        public void cancelled() {
            try {
                this.callback.cancelled();
            }
            finally {
                ((AtomicInteger)HttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }
    }
}

