/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service;

import cn.com.duiba.dao.MessageUniqueCheckDAO;
import cn.com.duiba.domain.MessageUniqueCheckDO;
import cn.com.duiba.service.KafkaClient;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

@Component
public class MessageService {
    private static Logger log = LoggerFactory.getLogger(MessageService.class);
    @Autowired
    private KafkaClient kafkaClient;
    @Autowired
    private MessageUniqueCheckDAO messageUniqueCheckDAO;
    @Autowired
    private Producer onsProducer;

    public String sendMsg(String queueName, String body) {
        log.warn("kafka sendMsg is @Deprecated queueName:" + queueName);
        return this.kafkaClient.sendMsg(queueName, body);
    }

    public String sendMsg(String topic, String tag, String key, String message) {
        Message msg = new Message(topic, tag, message.getBytes(Charset.forName("utf-8")));
        if (StringUtils.isNotEmpty((String)key)) {
            msg.setKey(key);
        }
        SendResult ret = this.onsProducer.send(msg);
        return ret.getMessageId();
    }

    public boolean messageUniqueCheck(String relationId, String relationType) {
        try {
            MessageUniqueCheckDO check = new MessageUniqueCheckDO();
            check.setRelationId(relationId);
            check.setRelationType(relationType);
            this.messageUniqueCheckDAO.insert(check);
            return true;
        }
        catch (DuplicateKeyException e) {
            log.error("\u91cd\u590d\u5411\u4e0a\u6e38\u8bf7\u6c42 supplierOrderId:" + relationId + " DuplicateKeyException", (Throwable)e);
            return false;
        }
    }
}

