/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.biz.credits.MogujieApi;
import cn.com.duiba.biz.credits.PajkApi;
import cn.com.duiba.biz.credits.TaojinbiApi;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.ThirdpartyRelationDAO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.HttpRequestLog;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class CustomServiceImpl
implements CustomService {
    private static Logger log = LoggerFactory.getLogger(CustomServiceImpl.class);
    private static final List<Long> NOTIFY_WITH_TRANSFER = Arrays.asList(24202L, 1L);
    private static final List<Long> pajkAppIds = Arrays.asList(27271L, 30703L, 31294L);
    @Value(value="${mogujie.appId}")
    private Long mogujieAppId;
    @Value(value="${taojinbi.appId}")
    private Long taojinbiAppId;
    @Autowired
    private MogujieApi mogujieApi;
    @Autowired
    private PajkApi pajkApi;
    @Autowired
    private TaojinbiApi taojinbiApi;
    @Autowired
    private ThirdpartyRelationDAO thirdpartyRelationDAO;

    @Override
    public boolean isMogujie(Long appId) {
        return this.mogujieAppId != null && this.mogujieAppId.equals(appId);
    }

    @Override
    public boolean isPajk(Long appId) {
        return appId != null && pajkAppIds.contains(appId);
    }

    @Override
    public boolean isTaojinbi(Long appId) {
        return this.taojinbiAppId != null && this.taojinbiAppId.equals(appId);
    }

    @Override
    public CreditsMessage getRequestCredits(CreditsMessage request) {
        if (request.getAppId() == null) {
            return request;
        }
        Long appId = Long.valueOf(request.getAppId());
        if (this.isMogujie(appId)) {
            return this.mogujieApi.getMogujieRequestCredits(request);
        }
        if (this.isPajk(appId)) {
            return this.pajkApi.getPajkRequestCredits(request);
        }
        if (this.isTaojinbi(appId)) {
            return this.taojinbiApi.getCreditsMessage(request);
        }
        return request;
    }

    @Override
    public String getResponseCredits(String appId, String body) {
        if (appId == null) {
            return body;
        }
        Long appIdLong = Long.valueOf(appId);
        if (this.isMogujie(appIdLong)) {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
            return this.mogujieApi.getMogujieResponseCredis(body);
        }
        if (this.isPajk(appIdLong)) {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
            return this.pajkApi.getPajkResponseCredits(appIdLong, body);
        }
        if (this.isTaojinbi(appIdLong)) {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
            return this.taojinbiApi.parseCreditsRsp(body);
        }
        return body;
    }

    @Override
    public String getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        try {
            if (this.isMogujie(record.getAppId())) {
                return this.mogujieApi.getMogujieRequestNotify(notifyUrl, record);
            }
            if (this.isPajk(record.getAppId())) {
                return this.pajkApi.getPajkRequestNotify(notifyUrl, record);
            }
        }
        catch (Exception e) {
            log.error("getRequestNotify", (Throwable)e);
        }
        return null;
    }

    @Override
    public String getResponseNotify(Long appId, String body) {
        try {
            if (this.isMogujie(appId)) {
                HttpRequestLog.logUrl("[action notify] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
                return this.mogujieApi.getMogujieResponseNotify(body);
            }
            if (this.isPajk(appId)) {
                HttpRequestLog.logUrl("[action notify] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
                return this.pajkApi.getPajkResponseNotify(body);
            }
        }
        catch (Exception e) {
            log.error("getResponseNotify", (Throwable)e);
        }
        return body;
    }

    @Override
    public Long getLongOrderNum(String duibaOrderNum) throws CodeException {
        if (StringUtils.isEmpty((String)duibaOrderNum)) {
            throw new CodeException("0", "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long lid = this.thirdpartyRelationDAO.findByOrderNum(duibaOrderNum);
        if (lid == null) {
            try {
                return this.thirdpartyRelationDAO.insert(duibaOrderNum);
            }
            catch (DuplicateKeyException e) {
                log.warn("thirdpartyRelationDAO.insert DuplicateKeyException", (Throwable)e);
                lid = this.thirdpartyRelationDAO.findByOrderNum(duibaOrderNum);
            }
        }
        return lid;
    }

    @Override
    public boolean isNotifyWithTransfer(Long appId) {
        return NOTIFY_WITH_TRANSFER.contains(appId);
    }

    @Override
    public Map<String, String> toRequestMapWithTransfer(String appSecret, CreditNotifyParams p, String transfer, String uid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("success", p.isSuccess() + "");
        map.put("errorMessage", this.getString(p.getErrorMessage()));
        map.put("bizId", this.getString(p.getBizId()));
        map.put("appKey", this.getString(p.getAppKey()));
        map.put("appSecret", this.getString(appSecret));
        map.put("timestamp", this.getString(p.getTimestamp().getTime()));
        map.put("uid", this.getString(uid));
        map.put("orderNum", this.getString(p.getOrderNum()));
        map.put("transfer", this.getString(transfer));
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }

    @Override
    public CreditsMessageDto getRequestAddCredits(CreditsMessageDto req) {
        if (req.getAppId() == null) {
            return req;
        }
        Long appId = Long.valueOf(req.getAppId());
        if (this.isMogujie(appId)) {
            return this.mogujieApi.getMogujieRequestAddCredits(req);
        }
        return req;
    }

    @Override
    public String getResponseAddCredits(String appId, String body) {
        if (appId == null) {
            return body;
        }
        Long appIdLong = Long.valueOf(appId);
        if (this.isMogujie(appIdLong)) {
            HttpRequestLog.logUrl("[action addCredits] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
            return this.mogujieApi.getMogujieResponseAddCredis(body);
        }
        return body;
    }

    @Override
    public SupplierRequest getVirturalRequest(SupplierRequest request) {
        if (request.getAppId() == null) {
            return request;
        }
        if (this.isMogujie(Long.valueOf(request.getAppId()))) {
            return this.mogujieApi.getMogujieRequestSendCredits(request);
        }
        return request;
    }

    @Override
    public String getVirturalResponse(SupplierRequest message, String body) {
        if (message.getAppId() == null) {
            return body;
        }
        if (this.isMogujie(Long.valueOf(message.getAppId()))) {
            return this.mogujieApi.getVirtualRespone(message, body);
        }
        return body;
    }
}

