/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.service.HttpRetryRulesService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HttpRetryRulesServiceImpl
implements HttpRetryRulesService {
    @Value(value="${default.retry.time}")
    private String defaultRetryConfig;
    @Value(value="${addcredits.retry.time}")
    private String addCreditsRetryConfig;
    @Autowired
    private HttpMessageDAO httpMessageDAO;

    @Override
    public String[] getDefaultRetry() {
        return this.defaultRetryConfig.split(",");
    }

    @Override
    public String[] getRetryRule(HttpMessageDO db) {
        if ("addCredits".equals(db.getBizType())) {
            return this.addCreditsRetryConfig.split(",");
        }
        return this.getDefaultRetry();
    }

    @Override
    public Integer getNextSecond(HttpMessageDO db) {
        int next = db.getNumber();
        String[] seconds = this.getRetryRule(db);
        return Integer.valueOf(seconds[next]);
    }

    @Override
    public Integer getRetryNumber(HttpMessageDO db) {
        String[] retry = this.getRetryRule(db);
        return retry.length;
    }

    @Override
    public void updateNextTime(HttpMessageDO db) {
        if (db.getId() == null) {
            HttpMessageDO insert = (HttpMessageDO)BeanUtils.copy((Object)db, HttpMessageDO.class);
            insert.setOffset(this.getNextSecond(db));
            insert.setNumber(1);
            this.httpMessageDAO.insert(insert);
            return;
        }
        this.httpMessageDAO.updateNextTime(db.getId(), this.getNextSecond(db));
    }
}

