/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleTool {
    private static Logger log = LoggerFactory.getLogger(AssembleTool.class);
    private static final String UTF8 = "utf-8";

    private AssembleTool() {
    }

    public static Map<String, String> getUrlParams(String urlParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)urlParams)) {
            return map;
        }
        String[] params = urlParams.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] p = params[i].split("=");
            if (p.length != 2) continue;
            String key = p[0];
            String value = p[1];
            if (StringUtils.isNotEmpty((String)value)) {
                try {
                    value = URLDecoder.decode(value, UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    log.error("URLDecoder.decode error:" + value, (Throwable)e);
                }
            }
            map.put(key, value);
        }
        return map;
    }

    public static String assembleUrl(String urlPar, Map<String, String> params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (str.toString().contains("?")) {
            str.append("&");
        } else {
            str.append("?");
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().length() == 0) {
                    str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), UTF8)).append("&");
            }
            catch (UnsupportedEncodingException e) {
                log.error("assembleUrl", (Throwable)e);
            }
        }
        return str.toString();
    }

    public static HttpPost assembleRequest(String url, Map<String, String> argParams) {
        Map<String, String> params = argParams;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair(entry.getKey(), value));
        }
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName(UTF8)));
        return post;
    }
}

