package cn.com.duiba.notifycenter.service.impl;

import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.AppNewExtraDao;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.BussinessTypesService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.Environment;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 通知业务数据封装
 */
@Service("bussinessTypesService")
public class BusinessTypeServiceImpl implements BussinessTypesService {

	private static Logger log = LoggerFactory.getLogger(BusinessTypeServiceImpl.class);

	@Autowired
	private Environment environment;
	@Autowired
	private AppDAO appDAO;
	@Autowired
	private CustomService customService;
	@Autowired
	private AppNewExtraDao appNewExtraDao;

	@Override
	public HttpUriRequest getRequest(NotifyQueueDO record) {
		try {
			DBTimeProfile.enter("getRequest");

			HttpUriRequest request;
			if(NotifyQueueDto.RT_RE_SIGN_CARD.equals(record.getRelationType())){
				request = getReSignRequest(record);
			}else{
				request = getCreditsRequest(record);
			}
			return request;
		} finally {
			DBTimeProfile.release();
		}
	}

	private HttpUriRequest getCreditsRequest(NotifyQueueDO record){
		AppDO app = appDAO.getAppByCache(record.getAppId());

		if (app.getCreditsConsumeNotifyUrl() == null || app.getCreditsConsumeNotifyUrl().length() == 0) {
			return null;
		}

		String errorMessage = "";
		if (record.getError4developer() != null) {
			errorMessage = record.getError4developer();
		}
		String uid = record.getPartnerUserId();
		if (uid == null) {
			uid = "";
		}
		String bizId = "";
		if (record.getDeveloperBizId() != null) {
			bizId = record.getDeveloperBizId();
		}

		CreditNotifyParams p = new CreditNotifyParams();
		p.setSuccess(record.getResult());
		p.setErrorMessage(errorMessage);
		p.setAppKey(app.getAppKey());
		p.setBizId(bizId);
		p.setUid(uid);
		p.setOrderNum(record.getDuibaOrderNum());
		String time="";
		if(customService.isMobike(app.getId())){
			time=String.valueOf(new Date().getTime()/1000L);
		}

		// 定制接口的APIURL/ 等于空就没有定制
		String customApiUrl = customService.getRequestNotify(app.getCreditsConsumeNotifyUrl(), record,time, app);
		if(StringUtils.isNotEmpty(customApiUrl)){
			HttpRequestBase request;
			if(customService.isIqiyi(app.getId())) {
				request = new HttpPost(customApiUrl);
			} else if(customService.isMobike(app.getId())){
				request = new HttpPost(customApiUrl);
				request.setHeader("time",time);
				request.setHeader("accesstoken",record.getTransfer());
			} else {
				request = new HttpGet(customApiUrl);
			}
			request.setConfig(getDefaultConfig());
			return request;
		}

		Map<String, String> map;
		if(customService.isNotifyWithTransfer(record.getAppId())){
			map = customService.toRequestMapWithTransfer(appDAO.getAppSecret(app),p,record.getTransfer(),uid);
		} else {
			map = p.toRequestMap(appDAO.getAppSecret(app));
		}

		HttpRequestBase request;
		if (Environment.PLACE_BAIDUYUN.equals(environment.getPlace())) {
			request = assembleRequest(app.getCreditsConsumeNotifyUrl(), map);
			request.setConfig(getDefaultConfig());
		} else {
			final String url = AssembleTool.assembleUrl(app.getCreditsConsumeNotifyUrl(), map);
			request = new HttpGet(url);
			request.setConfig(getDefaultConfig());
		}
		return request;
	}

	private HttpUriRequest getReSignRequest(NotifyQueueDO record) {
		DBTimeProfile.enter("getReSignRequest");

		AppDO app = appDAO.getAppByCache(record.getAppId());

		String url = appNewExtraDao.findVirtualCardConsumeNotify(record.getAppId());
		if(StringUtils.isBlank(url)){
			return null;
		}
		String errorMessage = record.getError4developer();
		String uid = record.getPartnerUserId();
		String bizId = record.getDeveloperBizId();

		/**
		 * 签名与扣积分相同
		 */
		CreditNotifyParams p = new CreditNotifyParams();
		p.setSuccess(record.getResult());
		p.setErrorMessage(errorMessage == null ? "" : errorMessage);
		p.setAppKey(app.getAppKey());
		p.setBizId(bizId == null ? "" : bizId);
		p.setUid(uid == null ? "" : uid);
		p.setOrderNum(record.getDuibaOrderNum());

		Map<String, String> map = p.toRequestMap(appDAO.getAppSecret(app));

		HttpRequestBase request = new HttpGet(AssembleTool.assembleUrl(url, map));
		request.setConfig(getDefaultConfig());
		return request;
	}

	/**
	 * 通知超时时间
	 * 
	 * @return
	 */
	private RequestConfig getDefaultConfig() {
		return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
	}

	/**
	 * 参数拼接URL
	 * 
	 * @param url
	 * @param params
	 * @return
	 */
	public HttpPost assembleRequest(String url, Map<String, String> params) {
		List<NameValuePair> pairs = new ArrayList<>(params.size());
		for (Map.Entry<String, String> entry : params.entrySet()) {
			String value = entry.getValue();
			if (value != null) {
				pairs.add(new BasicNameValuePair(entry.getKey(), value));
			}
		}
		HttpPost post = new HttpPost(url);
		post.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName("utf-8")));
		return post;
	}
}
