package cn.com.duiba.remoteimpl;

import cn.com.duiba.thirdparty.alarm.Dingding;
import cn.com.duiba.thirdparty.alarm.Mail;
import cn.com.duiba.thirdparty.alarm.Message;
import cn.com.duiba.thirdparty.api.RemoteAlarmService;
import cn.com.duiba.tool.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * 报警接口实现类
 */
@Service
public class RemoteAlarmServiceImpl implements RemoteAlarmService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChargeServiceImpl.class);

    @Override
    public DubboResult<Boolean> sendMail(String[] toMail, String title, String content, boolean isHtml) {
        try {
            return DubboResult.successResult(Mail.send(toMail, title, content, isHtml));
        } catch (Exception e) {
            LOGGER.error("sendMail", e);
            return DubboResult.failResult(ErrorCode.E9999999.getDesc());
        }
    }

    @Override
    public DubboResult<String> sendMessage(String phone, String text) {
        try {
            return DubboResult.successResult(Message.sned(phone, text));
        } catch (Exception e) {
            LOGGER.error("sendMessage", e);
            return DubboResult.failResult(ErrorCode.E9999999.getDesc());
        }
    }

    @Override
    public DubboResult<String> sendDingding(String robootKey, String text) {
        try {
            return DubboResult.successResult(Dingding.send(robootKey, text));
        } catch (Exception e) {
            LOGGER.error("sendDingding", e);
            return DubboResult.failResult(ErrorCode.E9999999.getDesc());
        }
    }
}
