package cn.com.duiba.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.service.HttpRetryRulesService;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * HTTP异常重试规则
 */
@Service
public class HttpRetryRulesServiceImpl implements HttpRetryRulesService {

	@Value("${default.retry.time}")
	private String defaultRetryConfig;

	@Value("${addcredits.retry.time}")
	private String addCreditsRetryConfig;

	@Autowired
	private HttpMessageDAO httpMessageDAO;

	@Override
	public String[] getDefaultRetry() {
		return defaultRetryConfig.split(",");
	}

	@Override
	public String[] getRetryRule(HttpMessageDO db) {
		if (HttpRequestMessageDto.RETRY_ADD_CREDITS.equals(db.getBizType())) {
			return addCreditsRetryConfig.split(",");
		}
		return getDefaultRetry();
	}

	@Override
	public Integer getNextSecond(HttpMessageDO db) {
		int next = db.getNumber();
		String[] seconds = getRetryRule(db);
		return Integer.valueOf(seconds[next]);
	}

	@Override
	public Integer getRetryNumber(HttpMessageDO db) {
		String[] retry = getRetryRule(db);
		return retry.length;
	}

	@Override
	public void updateNextTime(HttpMessageDO db) {
		if (db.getId() == null) {
			HttpMessageDO insert = BeanUtils.copy(db, HttpMessageDO.class);
			insert.setOffset(getNextSecond(db));
			insert.setNumber(1);
			httpMessageDAO.insert(insert);
			return;
		}
		httpMessageDAO.updateNextTime(db.getId(), getNextSecond(db));
	}

}
