package cn.com.duiba.biz.alipay.supplier;

import cn.com.duiba.biz.virtual.supplier.VirtualSupplier;
import cn.com.duiba.domain.MessageUniqueCheckDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 众想支付宝接口请求
 */
@Service
public class ZhongXiangSupplier {

	private static Logger log = LoggerFactory.getLogger(VirtualSupplier.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;

	/**
	 * 提交到HTTP请求池
	 * @param message
	 * @param callbackTopic
	 * @param msgTag
	 * @param msgKey
	 */
	public void asyncSubmit(final SupplierRequest message, final String callbackTopic, final String msgTag, final String msgKey) {
		if (!messageService.messageUniqueCheck(message.getSupplierOrderId(), MessageUniqueCheckDO.TYPE_ALIPAY)) {
			return;
		}
		HttpPost post = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
		HttpRequestLog.logUrl("[action zxalipay] [tag request] [bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "]");
		httpAsyncClientPool.submit(message.getAppId(), post, new FutureCallback<HttpResponse>() {

			@Override
			public void completed(HttpResponse response) {
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setSupplierName(message.getSupplierName());
					resp.setUrl(message.getHttpUrl());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_COMPLETED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
					String body = EntityUtils.toString(response.getEntity());
					resp.setBody(HttpRequestLog.subBody(body));
				} catch (Exception e) {
					log.error("ZhongXiangAlipaySupplier completed", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
				}
			}

			@Override
			public void failed(Exception ex) {
				log.error("VirtualSupplier failed orderId:" + message.getOrderId(), ex);
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_FAILED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
					resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
				} catch (Exception e) {
					log.error("ZhongXiangAlipaySupplier completed", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
				}
			}

			@Override
			public void cancelled() {
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_CANCELLED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
				} catch (Exception e) {
					log.error("ZhongXiangAlipaySupplier cancelled", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
				}
			}

		});

	}

	private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey) {
		try {
			response.setUrl(message.getHttpUrl());
			response.setSupplierName(message.getSupplierName());
			response.setSupplierOrderId(message.getSupplierOrderId());
			response.setOrderId(message.getOrderId());
			response.setAppId(message.getAppId());
			response.setConsumerId(message.getConsumerId());
			String body = JsonTool.objectToJson(response);
			HttpRequestLog.log.info("[action zxalipay] [tag response] [bizId " + message.getOrderId() + "] [supplierId " + message.getSupplierOrderId() + "] [callback " + response.getCallbackType() + "] [body " + response.getBody() + "]");
			messageService.sendMsg(callbackTopic, msgTag, msgKey, body);
		} catch (Exception e) {
			log.error("ZhongXiangAlipaySupplier callback:" + message.getOrderId(), e);
		}
	}

}
