package cn.com.duiba.biz.credits;

import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.TopSecretDO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by zzy on 2017/12/12.
 */
@Service
public class CainiaoApi {
    private static final Logger logger = LoggerFactory.getLogger(CainiaoApi.class);
    private static final ImmutableSet<Long> CAINIAO_APP_IDS = ImmutableSet.of(39305L, 40229L);

    private static final ImmutableMap<String, String> CREDITS_ID_MAP;
    private static final ImmutableMap<String, String> CREDITS_FEILD_MAP;
    public static final String SUB_CREDITS_METHOD = "cainiao.nbmarketcenter.duiba.credits.consume";
    public static final String CREDIT_CONSUMER_REQUEST_PARAM = "credit_consumer_request";

    public static final String NOTIFY_CALLBACK_METHOD = "cainiao.nbmarketcenter.duiba.credits.notify.callback";
    public static final String CREDIT_EXCHANGE_RECORD_PARAM = "credit_exchange_record_params";

    public static final String CRECORD_NOTIFY_METHOD = "cainiao.nbmarketcenter.duiba.credits.exchange.record";
    public static final String CREDIT_NOTIFY_PARAM = "credit_notify_params";

    @Autowired
    private AppDAO appDAO;

    static {
        Map<String, String> tempMap = new HashMap<>();
        tempMap.put("0", "121");
        tempMap.put("50", "92");
        tempMap.put("100", "93");
        tempMap.put("200", "94");
        tempMap.put("300", "95");
        tempMap.put("400", "96");
        tempMap.put("500", "97");
        tempMap.put("600", "98");
        tempMap.put("700", "99");
        tempMap.put("800", "100");
        tempMap.put("900", "101");
        tempMap.put("1000", "102");
        tempMap.put("1500", "103");
        tempMap.put("2000", "104");
        tempMap.put("3000", "105");
        tempMap.put("5000", "106");
        tempMap.put("10000", "107");
        CREDITS_ID_MAP = ImmutableMap.copyOf(tempMap);

        //限定参数，扣积分，如果传过去未知的参数恰是驼峰规则top会报错
        CREDITS_FEILD_MAP = new ImmutableMap.Builder<String, String>()
                .put("uid", "uid")
                .put("credits", "credits")
                .put("creditsId", "credits_id")
                .put("itemCode", "item_code")
                .put("appKey", "duiba_app_key")
                .put("timestamp", "duiba_timestamp")
                .put("description", "description")
                .put("orderNum", "order_num")
                .put("type", "type")
                .put("actualPrice", "actual_price")
                .put("facePrice", "face_price")
                .put("ip", "ip")
                .put("waitAudit", "wait_audit")
                .put("params", "params")
                .put("appSecret", "appSecret")
                .build();
    }

    private TopSecretDO getTopSecretDO(Long appId) {
        //正式环境
        String appKey = "24327934";
        String secret = "c290043acee4a46c99c47c6382b99f2c";
        //兼容测试环境
        if (appId == 39305) {
            appKey = "1024327934"; // 可替换为您的沙箱环境应用的appKey
            secret = "sandboxacee4a46c99c47c6382b99f2c"; // 可替换为您的沙箱环境应用的appSecret
        }
        TopSecretDO topSecretDO = new TopSecretDO();
        topSecretDO.setAppKey(appKey);
        topSecretDO.setAppSecret(secret);

        return topSecretDO;
    }

    /**
     * 判断是否是菜鸟裹裹appId
     *
     * @param appId
     * @return
     */
    public static boolean isCainiao(Long appId) {
        return CAINIAO_APP_IDS.contains(appId);
    }

    /**
     * 拼装菜鸟裹裹减积分请求url
     * 添加creditsId字段
     *
     * @param request
     * @return
     */
    public CreditsMessage getRequestCredits(CreditsMessage request) {
        TopSecretDO topSecretDO = getTopSecretDO(Long.valueOf(request.getAppId()));
        topSecretDO.setAddPrefix(false);

        Map<String, String> authParams = request.getAuthParams();
        if (MapUtils.isEmpty(authParams)) {
            throw new IllegalStateException("cainiao api authParams is empty!");
        }
        String credits = authParams.get("credits");
        String creditsId = CREDITS_ID_MAP.get(credits);
        if (creditsId != null) {
            // 菜鸟裹裹需要添加creditsId
            authParams.put("creditsId", creditsId);
        } else {
            logger.warn("cainiao api credits[()] is invalid!", credits);
        }
        authParams.remove("sign");

        Map<String, String> params = CaiNiaoTool.buildParamMap(authParams, SUB_CREDITS_METHOD, CREDIT_CONSUMER_REQUEST_PARAM, CREDITS_FEILD_MAP, topSecretDO);
        String url = request.getHttpUrl().substring(0, request.getHttpUrl().indexOf('?'));
        request.setHttpUrl(url);
        request.setHttpType(CreditsMessage.HTTP_POST);
        request.setAuthParams(params);
        return request;
    }

    /**
     * 拼装菜鸟裹裹通知请求url
     *
     * @return
     */
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO app, CreditNotifyParams notifyParams) {
        TopSecretDO topSecretDO = getTopSecretDO(record.getAppId());
        topSecretDO.setAddPrefix(false);

        Map<String, String> authParams = new HashMap<>();
        authParams.put("success", String.valueOf(notifyParams.isSuccess()));
        authParams.put("error_message", notifyParams.getErrorMessage());
        authParams.put("biz_id", notifyParams.getBizId());
        authParams.put("duiba_app_key", app.getAppKey());
        authParams.put("appSecret", appDAO.getAppSecret(app));
        authParams.put("duiba_timestamp", DateUtils.getSecondStr(new Date()));
        authParams.put("uid", record.getPartnerUserId());
        authParams.put("order_num", notifyParams.getOrderNum());

        Map<String, String> params = CaiNiaoTool.buildParamMap(authParams, NOTIFY_CALLBACK_METHOD, CREDIT_NOTIFY_PARAM, null, topSecretDO);
        HttpRequestBase http = CaiNiaoTool.setHttpRequestHeader(notifyUrl, params);
        return http;
    }



    /**
     * 拼装菜鸟裹裹兑换记录请求url
     *
     * @return
     */
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        TopSecretDO topSecretDO = getTopSecretDO(app.getId());
        topSecretDO.setAddPrefix(false);

        Map<String, String> authParams = new HashMap<>();
        authParams.put("uid", msg.getHttpParams().get("uid"));
        authParams.put("title", msg.getHttpParams().get("title"));
        authParams.put("record_detail_url", msg.getHttpParams().get("recordDetailUrl"));
        authParams.put("credits", msg.getHttpParams().get("credits"));
        authParams.put("appSecret", appDAO.getAppSecret(app));
        if (StringUtils.isBlank(msg.getHttpParams().get("timestamp"))) {
            authParams.put("duiba_timestamp", DateUtils.getSecondStr(new Date()));
        } else {
            authParams.put("duiba_timestamp", DateUtils.getSecondStr(Long.valueOf(msg.getHttpParams().get("timestamp"))));
        }
        authParams.put("duiba_app_key", app.getAppKey());
        authParams.put("logo_url", msg.getHttpParams().get("logoUrl"));
        authParams.put("record_id", msg.getHttpParams().get("recordId"));
        //普兑才会传orderNum, 活动不传，否则会导致签名失败
        if (msg.getHttpParams().get("orderNum") != null) {
            authParams.put("order_num", msg.getHttpParams().get("orderNum"));
        }


        Map<String, String> params = CaiNiaoTool.buildParamMap(authParams, CRECORD_NOTIFY_METHOD, CREDIT_EXCHANGE_RECORD_PARAM, null, topSecretDO);
        HttpRequestBase http = CaiNiaoTool.setHttpRequestHeader(app.getRecordNotifyUrl(), params);
        HttpRequestLog.logUrl("[action crecord] [tag post request] [url " + app.getRecordNotifyUrl() + "][param " + JSONObject.toJSONString(params) + "]");
        return http;
    }

    /**
     * 解析菜鸟裹裹的响应
     * 响应样例：
     * <p/>
     * <p/>
     * {
     * "cainiao_nbmarketcenter_duiba_credits_consume_response": {
     * "result": "{\"bizId\":\"345444\",\"credits\":\"1222\",\"errorMessage\":\"\",\"status\":\"ok\"}",
     * "request_id": "d456ukasmol2"
     * }
     * }
     *
     * @param body
     * @return
     */
    public String parseCreditsRsp(String body) {
        JSONObject jsonObject;
        try {
            if (StringUtils.isBlank(body)) {
                return body;
            }
            jsonObject = JSONObject.parseObject(body);
        } catch (Exception e) {
            logger.error("JSON.parseObject:", e);
            return body;
        }

        JSONObject duibaRspJsonWrap = jsonObject.getJSONObject("cainiao_nbmarketcenter_duiba_credits_consume_response");
        if (duibaRspJsonWrap == null) {
            return body;
        }
        String duibaRspJson = duibaRspJsonWrap.getString("result");
        if (StringUtils.isBlank(duibaRspJson)) {
            return body;
        }
        return duibaRspJson;
    }


}
