package cn.com.duiba.biz.credits;

import cn.com.duiba.dao.ThirdpartyRelationDAO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 蘑菇街对接API
 */
@Service
public class MogujieApi {

    private static Logger log = LoggerFactory.getLogger(MogujieApi.class);

    /**
     * 蘑菇街分配的appKey
     */
    private String mogujieAppKey = "100429";
    /**
     * 蘑菇街分配的appSecret
     */
    private String mogujieAppSecert = "0CE1E6E0C179AAD734E7FF8B65E24C42";
    /**
     * 蘑菇街分配的apiMethod
     */
    private String mogujieMethodCredits = "mogujie.member.modou.freeze.initiate";
    /**
     * 蘑菇街分配的apiMethod
     */
    private String mogujieMethodNotify = "mogujie.member.modou.freeze.notify";
    /**
     * 蘑菇街分配的apiFormat
     */
    private String mogujieFormat = "json";
    /**
     * 蘑菇街分配的marketItemKey
     */
    private String mogujieMarketItemKey = "DUIBA_FREEZE";
    
    /**
     * 蘑菇街分配的发送蘑豆的marketItemKey
     */
    private String mogujieSendModouMarketItemKey = "DUIBA_REWARD_SEND";

    
    private String mogujieMethodSend = "mogujie.member.modou.notice.send";

    @Autowired
    private ThirdpartyRelationDAO thirdpartyRelationDAO;

    /**
     * 获取蘑菇街扣积分请求参数
     *
     * @param request
     * @return
     */
    public CreditsMessage getMogujieRequestCredits(CreditsMessage request) {
        try {
            String url = request.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            String params = url.substring(url.indexOf('?') + 1, url.length());
            // 1.将请求URL的参数转换为MAP
            Map<String, String> crediMap = AssembleTool.getUrlParams(params);
            // 兑吧的String订单号转为Long订单号
            Long orderNum = getLongOrderNum(crediMap.get("orderNum"));
            // 2.蘑菇街参数封装
            Map<String, String> mogujieParams = new HashMap<>();
            mogujieParams.put("app_key", mogujieAppKey);
            mogujieParams.put("method", mogujieMethodCredits);
            mogujieParams.put("format", mogujieFormat);
            mogujieParams.put("timestamp", String.valueOf(new Date().getTime()));
            mogujieParams.put("access_token", crediMap.get("transfer"));
            Map<String, Object> credits = new HashMap<>();
            credits.put("businessId", orderNum);
            credits.put("marketItemKey", mogujieMarketItemKey);
            credits.put("coinAmount", crediMap.get("credits"));
            credits.put("token", crediMap.get("uid"));
            mogujieParams.put("openApiInitiateFreezeCoinParam", JSONObject.toJSONString(credits));
            // 3.参数签名
            mogujieParams.put("sign", sign(mogujieAppSecert, mogujieParams));
            // 4.生成URL
            String requestUrl = AssembleTool.assembleUrl(host, mogujieParams);
            request.setHttpUrl(requestUrl);
            request.setHttpType(CreditsMessage.HTTP_GET);
            request.setAuthParams(new HashMap<String, String>());
            return request;
        } catch (Exception e) {
            log.error("getMogujieRequestCreditsURL:", e);
            return request;
        }
    }

    /**
     * 转义蘑菇街扣积分响应数据
     *
     * @param body
     * @return
     */
    public String getMogujieResponseCredis(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            log.error("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        Map<String, String> duibaDoc = new HashMap<>();
        String code = json.getString("code");
        if ("0000000".equals(code)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("msg"));
        duibaDoc.put("bizId", json.getString("bizId"));
        duibaDoc.put("credits", json.getString("coinBalance"));
        return JsonTool.objectToJson(duibaDoc);
    }

    /**
     * 获取蘑菇街通知请求参数
     *
     * @return
     */
    public HttpRequestBase getMogujieRequestNotify(String url, NotifyQueueDO queue) {
        try {
            // 兑吧的String订单号转为Long订单号
            Long orderNum = getLongOrderNum(queue.getDuibaOrderNum());
            // 1.封装参数
            Map<String, String> mogujieParams = new HashMap<>();
            mogujieParams.put("app_key", mogujieAppKey);
            mogujieParams.put("method", mogujieMethodNotify);
            mogujieParams.put("format", mogujieFormat);
            mogujieParams.put("timestamp", String.valueOf(new Date().getTime()));
            mogujieParams.put("access_token", queue.getTransfer());
            Map<String, Object> notify = new HashMap<>();
            notify.put("businessId", orderNum);
            notify.put("marketItemKey", mogujieMarketItemKey);
            notify.put("success", queue.getResult());
            notify.put("errorMessage", queue.getError4developer());
            notify.put("bizId", queue.getDeveloperBizId());
            notify.put("token", queue.getPartnerUserId());
            mogujieParams.put("openApiFreezeCoinParam", JSONObject.toJSONString(notify));
            // 2.参数签名
            mogujieParams.put("sign", sign(mogujieAppSecert, mogujieParams));
            // 3.生成请求URL
            return new HttpGet(AssembleTool.assembleUrl(url, mogujieParams));
        } catch (CodeException e) {
            log.error("getMogujieRequestNotify", e);
            return null;
        }
    }

    /**
     * 获取蘑菇街通知响应
     *
     * @param body
     * @return
     */
    public String getMogujieResponseNotify(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            log.error("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        String code = json.getString("code");
        if ("0000000".equals(code)) {
            return "ok";
        }
        return body;
    }

    /**
     * 蘑菇街签名生成规则:<br/>
     * 根据参数名称将所有请求参数按照字母先后顺序排序：key + value .... key + value。 <br/>
     * 例如参数输入：foo=1&bar=2&baz=3，
     * 排序后为bar=2,baz=3,foo=1，参数名和参数值链接后，得到拼装字符串bar2baz3foo1。<br/>
     * 将appSecret拼接到参数字符串头、尾进行md5校验，再将结果转化成大写，如：Uppercase(md5(
     * secretkey1value1key2value2...secret))。<br/>
     *
     * @param secret
     * @param params
     * @return
     */
    private String sign(String secret, Map<String, String> params) {
        List<String> keys = new ArrayList<>(params.keySet());
        Collections.sort(keys);
        StringBuilder string = new StringBuilder();
        string.append(secret);
        for (String key : keys) {
            string.append(key).append(params.get(key));
        }
        string.append(secret);
        return DigestUtils.md5Hex(string.toString()).toUpperCase();
    }

    
	public CreditsMessageDto getMogujieRequestAddCredits(
			CreditsMessageDto req) {
		try {
            String url = req.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            String params = url.substring(url.indexOf('?') + 1, url.length());
            // 1.将请求URL的参数转换为MAP
            Map<String, String> crediMap = AssembleTool.getUrlParams(params);
            // 兑吧的String订单号转为Long订单号
            Long orderNum = getLongOrderNum(crediMap.get("orderNum"));
            // 2.蘑菇街参数封装
            Map<String, String> mogujieParams = new HashMap<>();
            mogujieParams.put("app_key", mogujieAppKey);
            mogujieParams.put("method", mogujieMethodSend);
            mogujieParams.put("format", mogujieFormat);
            mogujieParams.put("timestamp", String.valueOf(new Date().getTime()));
            mogujieParams.put("access_token", crediMap.get("transfer"));
            Map<String, Object> credits = new HashMap<>();
            credits.put("businessId", orderNum);
            credits.put("marketItemKey", mogujieSendModouMarketItemKey);
            credits.put("coinAmount", crediMap.get("credits"));
            mogujieParams.put("baseOpenApiCoinParam", JSONObject.toJSONString(credits));
            // 3.参数签名
            mogujieParams.put("sign", sign(mogujieAppSecert, mogujieParams));
            // 4.生成URL
            String requestUrl = AssembleTool.assembleUrl(host, mogujieParams);
            req.setHttpUrl(requestUrl);
            return req;
        } catch (Exception e) {
            log.error("getMogujieAddRequestCreditsURL:", e);
            return req;
        }
	}

	
	public String getMogujieResponseAddCredis(String body) {
		JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            log.error("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        Map<String, String> duibaDoc = new HashMap<>();
        String code = json.getString("code");
        if ("0000000".equals(code)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("msg"));
        duibaDoc.put("bizId", json.getString("bizId"));
        duibaDoc.put("credits", json.getString("coinBalance"));
        return JsonTool.objectToJson(duibaDoc);
	}

	public SupplierRequest getMogujieRequestSendCredits(
			SupplierRequest request) {
		try {
			String url = request.getHttpUrl();
			String host = url.substring(0, url.indexOf('?'));
			String params = url.substring(url.indexOf('?') + 1, url.length());
			// 1.将请求URL的参数转换为MAP
			Map<String, String> crediMap = AssembleTool.getUrlParams(params);
			// 判断一下是不是魔豆
			String keys = crediMap.get("params");
			JSONObject json = JSON.parseObject(keys);
			// 是否是魔豆奖品
			if (!"modou".equals(json.get("prizeType"))) {
				return request;
			}
			// 兑吧的String订单号转为Long订单号
			Long orderNum = getLongOrderNum(crediMap.get("orderNum"));
			// 2.蘑菇街参数封装
			Map<String, String> mogujieParams = new HashMap<>();
			mogujieParams.put("app_key", mogujieAppKey);
			mogujieParams.put("method", mogujieMethodSend);
			mogujieParams.put("format", mogujieFormat);
			mogujieParams.put("timestamp",
					String.valueOf(new Date().getTime()));
			// access_token取自order
			mogujieParams.put("access_token", request.getParams().get("transfer"));

			Map<String, Object> credits = new HashMap<>();
			credits.put("businessId", orderNum);
			credits.put("marketItemKey", mogujieSendModouMarketItemKey);
			credits.put("coinAmount",json.get("num"));
			mogujieParams.put("baseOpenApiCoinParam",
					JSONObject.toJSONString(credits));
			// 3.参数签名
			mogujieParams.put("sign", sign(mogujieAppSecert, mogujieParams));
			// 4.生成URL
			String requestUrl = AssembleTool.assembleUrl(host, mogujieParams);
			request.setHttpUrl(requestUrl);
			return request;
		} catch (Exception e) {
			log.error("getMogujieRequestCreditsURL:", e);
			return request;
		}
	}


	public String getVirtualRespone(String body) {
		JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            log.error("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        Map<String, String> duibaDoc = new HashMap<>();
        String code = json.getString("code");
        if ("0000000".equals(code)) {
            duibaDoc.put("status", "success");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("msg"));
        duibaDoc.put("supplierBizId", json.getString("bizId"));
        duibaDoc.put("credits", json.getString("coinBalance"));
        return JsonTool.objectToJson(duibaDoc);
	}

    public Long getLongOrderNum(String duibaOrderNum) throws CodeException {
        if (StringUtils.isEmpty(duibaOrderNum)) {
            throw new CodeException("0", "订单号不能为空");
        }
        Long lid = thirdpartyRelationDAO.findByOrderNum(duibaOrderNum);
        if (lid == null) {
            try {
                return thirdpartyRelationDAO.insert(duibaOrderNum);
            } catch (DuplicateKeyException e) {
                log.warn("thirdpartyRelationDAO.insert DuplicateKeyException", e);
                lid = thirdpartyRelationDAO.findByOrderNum(duibaOrderNum);
            }
        }
        return lid;
    }
	
}
