package cn.com.duiba.biz.credits;

import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSONObject;
import com.pajk.openapi.codec.client.RequestEncoder;
import com.pajk.openapi.codec.client.RequestEntity;
import com.pajk.openapi.codec.client.ResponseDecoder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 平安健康对接API
 */
@Service
public class PajkApi {

	private static Logger log = LoggerFactory.getLogger(PajkApi.class);

	/** 平安健康分配的parterId */
	private String partnerId = "trident_duiba";
	/** 平安健康分配的key */
	private String key = "093e8b1f727182894410efbc9c16a84b";
	private String keyPre = "093e8b1f727182894410efbc9c16a84b";
    private String keyTest = "5ddb78e413e1e9510fd983fb4a116dee";

    /** 平安健康apiGroup */
	private String apiGroup = "trident";

	/** 平安健康分配的扣积分appId */
	private String apiIdCredits = "9f033270b54892f8adaa0a6913224673#PROD";
    private String apiIdCreditsPre = "9f033270b54892f8adaa0a6913224673#PRE";
    private String apiIdCreditsTest = "9f033270b54892f8adaa0a6913224673#TEST";

    /** 平按健康用户扣减积分接口名称 */
	private String apiNameCredits = "deduction";

	/** 平安健康分配的通知appId */
	private String apiIdNotify = "438e76174243c37d688685f4c7557c4d#PROD";

    /** 平按健康用户扣减积分接口名称 */
	private String apiNameNotify = "callBack";

	private Long preAppId = 31294L;
	private Long testAppId = 30703L;

	private RequestEncoder getRequestEncoder(Long appId){
	    if(preAppId.equals(appId)){
            return new RequestEncoder(partnerId, keyPre, apiIdCreditsPre);
        }
        if(testAppId.equals(appId)){
            return new RequestEncoder(partnerId, keyTest, apiIdCreditsTest);
        }
        return new RequestEncoder(partnerId, key, apiIdCredits);
    }

    private ResponseDecoder getResponseEncoder(Long appId){
        if(preAppId.equals(appId)){
            return new ResponseDecoder(keyPre);
        }
        if(testAppId.equals(appId)){
            return new ResponseDecoder(keyTest);
        }
        return new ResponseDecoder(key);
    }

	/**
	 * 获取平安健康扣积分请求参数
	 * 
	 * @param request
	 * @return
	 */
	public CreditsMessage getPajkRequestCredits(CreditsMessage request) {
		try {
			String url = request.getHttpUrl();
			String host = url.substring(0, url.indexOf('?'));
			String params = url.substring(url.indexOf('?') + 1, url.length());
			Map<String, String> creditsMap = AssembleTool.getUrlParams(params);
			RequestEncoder encoder = getRequestEncoder(Long.valueOf(request.getAppId()));
			encoder.addParameter(JSONObject.toJSONString(creditsMap));
			RequestEntity e = encoder.encode();
			String pajkUrl = host + "/" + apiGroup + "/" + apiNameCredits + "?" + e.getQueryParams() + "&" + e.getFormParams();
			request.setHttpUrl(pajkUrl);
			request.setHttpType(CreditsMessage.HTTP_GET);
			request.setAuthParams(new HashMap<String, String>());
			return request;
		} catch (Exception e) {
			log.error("getPajkRequestCredits:", e);
			return request;
		}
	}
	
	/**
	 * 获取平安健康扣积分响应
	 * 
	 * @param body
	 * @return
	 */
	public String getPajkResponseCredits(Long appId, String body){
		JSONObject bodyJson = JSONObject.parseObject(body);
		if(!"0".equals(bodyJson.getString("code"))){
			Map<String, String> map = new HashMap<>();
			map.put("status", "fail");
			map.put("errorMessage", bodyJson.getString("tips")+" "+bodyJson.getString("message"));
			return JSONObject.toJSONString(map);
		}
		ResponseDecoder d = getResponseEncoder(appId);
		boolean decode = d.decode(bodyJson.getString("object"));
		if(!decode){
			Map<String, String> map = new HashMap<>();
			map.put("status", "fail");
			map.put("errorMessage", "ResponseDecoder失败");
			return JSONObject.toJSONString(map);
		}
		String decodeData = d.getData();
		JSONObject data = JSONObject.parseObject(decodeData);
		Map<String, Object> map = new HashMap<>();
		map.put("status", data.get("status"));
		map.put("errorMessage", data.get("errorMessage"));
		map.put("bizId", data.get("bizId"));
		map.put("credits", data.get("credits"));
		return JSONObject.toJSONString(map);
	}

	/**
	 * 获取平安健康通知请求参数
	 * 
	 * @param url
	 * @param queue
	 * @return
	 */
	public HttpRequestBase getPajkRequestNotify(String url, NotifyQueueDO queue) {
		try {
			RequestEncoder encoder = new RequestEncoder(partnerId, key, apiIdNotify);
			Map<String, Object> map = new HashMap<>();
			map.put("timestamp", String.valueOf(new Date().getTime()));
			map.put("success", queue.getResult());
			map.put("errorMessage", queue.getError4developer());
			map.put("orderNum", queue.getDuibaOrderNum());
			map.put("bizId", queue.getDeveloperBizId());
			encoder.addParameter(JSONObject.toJSONString(map));
			RequestEntity e = encoder.encode();
			return new HttpGet(url + "/" + apiGroup + "/" + apiNameNotify + "?" + e.getQueryParams() + "&" + e.getFormParams());
		} catch (Exception e) {
			log.error("getPajkRequestNotify", e);
			return null;
		}
	}
	
	/**
	 * 获取平安健康通知响应
	 * @param body
	 * @return
	 */
	public String getPajkResponseNotify(String body) {
		JSONObject bodyJson = JSONObject.parseObject(body);
		if (!"0".equals(bodyJson.getString("code"))) {
			return "fail";
		}
		return "ok";
	}

}
