package cn.com.duiba.biz.virtual;

import cn.com.duiba.biz.credits.CainiaoApi;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.TopSecretDO;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

/**
 * Created by xutao on 2018/3/5.
 */
@Service
public class AliTripApi {
    private static final Logger logger = LoggerFactory.getLogger(CainiaoApi.class);
    private static final ImmutableSet<Long> ALITRIP_APP_IDS = ImmutableSet.of(43739L, 43740L);
    private static final ImmutableMap<String, String> PARAM_FEILD_MAP;
    private static final ImmutableMap<String, String> RESULT_FEILD_MAP;

    public static final String ALITRIP_VIRTUAL_AWARD_METHOD = "alitrip.wireless.duiba.award";
    public static final String ALITRIP_VIRTUAL_AWARD_REQUEST = "alitrip_virtual_award_request";

    public static final String ALITRIP_VIRTUAL_AWARD_RESPONSE = "alitrip_wireless_duiba_award_response";

    @Autowired
    private AppDAO appDAO;

    static {
        //限定参数，扣积分，如果传过去未知的参数恰是驼峰规则top会报错
        PARAM_FEILD_MAP = new ImmutableMap.Builder<String, String>()
                .put("appKey", "duiba_app_key")
                .put("orderNum", "order_num")
                .put("developBizId", "develop_biz_id")
                .build();

        RESULT_FEILD_MAP = new ImmutableMap.Builder<String, String>()
                .put("supplier_biz_id", "supplierBizId")
                .put("error_message", "errorMessage")
                .build();
    }

    private TopSecretDO getTopSecretDO(String appId) {
        //正式环境
        String appKey = "24327934";
        String secret = "c290043acee4a46c99c47c6382b99f2c";
        //兼容测试环境
        if (Objects.equals("" + 43739, appId)) {
            appKey = "1024327934"; // 可替换为您的沙箱环境应用的appKey
            secret = "sandboxacee4a46c99c47c6382b99f2c"; // 可替换为您的沙箱环境应用的appSecret
        }
        TopSecretDO topSecretDO = new TopSecretDO();
        topSecretDO.setAppKey(appKey);
        topSecretDO.setAppSecret(secret);

        return topSecretDO;
    }

    /**
     * 判断是否是飞猪appId
     *
     * @param appId
     * @return
     */
    public static boolean isAliTrip(Long appId) {
        return ALITRIP_APP_IDS.contains(appId);
    }

    /**
     * 虚拟商品上游兑换Request
     * @param request
     * @return
     */
    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> requestMap = AssembleTool.getUrlParams(urlParams);

        TopSecretDO topSecretDO = getTopSecretDO(request.getAppId());
        topSecretDO.setAddPrefix(true);

        if (MapUtils.isEmpty(requestMap)) {
            throw new IllegalStateException("alitrip api params is empty!");
        }
        requestMap.remove("sign");
        requestMap.put(CaiNiaoTool.DUIBA_PREFIX + "appSecret", appDAO.getAppSecret(appDAO.getAppByCache(Long.valueOf(request.getAppId()))));

        Map<String, String> authParams = CaiNiaoTool.buildParamMap(requestMap, ALITRIP_VIRTUAL_AWARD_METHOD, ALITRIP_VIRTUAL_AWARD_REQUEST, PARAM_FEILD_MAP, topSecretDO);
        request.setHttpUrl(host);
        request.setAuthParams(authParams);
        return request;
    }

    /**
     * 解析飞猪的响应
     * 响应样例：
     * <p/>
     * <p/>
     * {"alitrip_wireless_duiba_award_response":
     *  {"credits":0,"status":"success","supplier_biz_id":"61d03b74-c969-48c7-a2f0-676ac8306959","request_id":"153ignduvqcxo"}
     * }
     *
     * @param body
     * @return
     */
    public String parseVirtualResponse(String body) {
        JSONObject jsonObject;
        try {
            if (StringUtils.isBlank(body)) {
                return body;
            }
            jsonObject = JSONObject.parseObject(body);
        } catch (Exception e) {
            logger.error("JSON.parseObject:", e);
            return body;
        }

        JSONObject duibaRspJsonWrap = jsonObject.getJSONObject(ALITRIP_VIRTUAL_AWARD_RESPONSE);
        if (duibaRspJsonWrap == null) {
            return body;
        }

        return JSONObject.toJSONString(duibaRspJsonWrap);
    }

    /**
     * 虚拟商品上游兑换Respone
     * @param body
     * @return
     */
    public  String getVirtualRespone(String body) {
        String result = parseVirtualResponse(body);
        if(StringUtils.isNotBlank(result)){
            for(Map.Entry<String, String> entry : RESULT_FEILD_MAP.entrySet()){
                result = result.replace(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }
}
