package cn.com.duiba.dao.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;

/**
 * HTTP异常重试
 */
@Repository("httpMessageDAO")
public class HttpMessageDAOImpl extends BaseDAO implements HttpMessageDAO {
	
	@Override
	public HttpMessageDO find(Long id) {
		Map<String, Object> map = new HashMap<>();
		map.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), map);
	}

	@Override
	public void insert(HttpMessageDO message) {
		getSqlSession().insert(getStamentNameSpace("insert"), message);
	}

	@Override
	public int updateNextTime(long id, int offset) {
		Map<String, Object> map = new HashMap<>();
		map.put("offset", offset);
		map.put("id", id);
		return getSqlSession().update(getStamentNameSpace("updateNextTime"), map);
	}

	@Override
	public int delete(Long id) {
		if (id == null) {
			return 0;
		}
		Map<String, Object> map = new HashMap<>();
		map.put("id", id);
		return getSqlSession().delete(getStamentNameSpace("delete"), map);
	}

	@Override
	public List<HttpMessageDO> findNeedRetry(String bizType, int limit) {
		Map<String, Object> map = new HashMap<>();
		map.put("nextTime", new Date());
		map.put("bizType", bizType);
		map.put("limit", limit);
		return getSqlSession().selectList(getStamentNameSpace("findNeedRetry"), map);
	}

}
