package cn.com.duiba.notifycenter.dao;

import java.util.Date;
import java.util.List;

import cn.com.duiba.notifycenter.domain.NotifyQueueDO;

/**
 * 通知DAO
 */
public interface NotifyQueueDAO {
	
	/**
	 * 查询需要重试通知的列表
	 * @return
	 */
	public List<NotifyQueueDO> findNeedNotifyList();
	
	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	public NotifyQueueDO find(Long id);
	
	/**
	 * 删除统计记录
	 * @param id
	 */
	public void finish(Long id);
	
	/**
	 * 修改下次通知时间
	 * @param id
	 * @param times
	 * @param nextTime
	 * @return
	 */
	public int updateNextTime(Long id,int times,Date nextTime);
	
	/**
	 * 新增一条通知记录
	 * @param notifyQueueDO
	 */
	public void insert(NotifyQueueDO notifyQueueDO);
	
}
