package cn.com.duiba.notifycenter.remoteimpl;

import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.thirdparty.api.RemoteNotifyDeveloperService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * 通知服务接口
 */
@RestController
public class RemoteNotifyQueueServiceImpl implements RemoteNotifyDeveloperService {

	private static Logger log = LoggerFactory.getLogger(RemoteNotifyQueueServiceImpl.class);

	@Autowired
	private NotifyQueueDAO notifyQueueDAO;
	@Autowired
	private NotifyService notifyService;

	@Override
	public void notifyDeveloper(NotifyQueueDto notifyQueue) {
		try {
			NotifyQueueDO queue = BeanUtils.copy(notifyQueue, NotifyQueueDO.class);
			DBTimeProfile.enter("insert");
			if(queue.getTimes() == null){
                queue.setTimes(0);
			}
			if(queue.getNotifyType() == null){//默认结果通知，向上兼容
				queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
			}
			if(NotifyTypeEnum.getByCode(queue.getNotifyType())==null){
				throw new Exception("通知类型不存在;queue:"+ JSON.toJSONString(queue));
			}

			String errorMsg = queue.getError4developer();
			if(StringUtils.isNotBlank(errorMsg) && errorMsg.length() > 500){
				queue.setError4developer(errorMsg.substring(0, 500));
			}

			notifyQueueDAO.insert(queue);
			DBTimeProfile.release();
			DBTimeProfile.enter("notify");
			notifyService.notify(queue, "remote call");
			DBTimeProfile.release();
		} catch (Exception e) {
			log.error("notify error", e);
		}
	}

}
