package cn.com.duiba.notifycenter.service;

import cn.com.duiba.notifycenter.domain.NotifyQueueDO;

import java.util.Date;

/**
 * 通知服务
 */
public interface NotifyService {

	/**
	 * 通知开发者
	 * 
	 * @param queue
	 */
	public void notify(NotifyQueueDO queue, String fromSource);

	/**
	 * 获取下次通知时间
	 * 
	 * @param queue
	 * @return 下一次通知时间
	 */
	public Date getNextTime(NotifyQueueDO queue);

	/**
	 * 扫描数据库中需要通知的记录，进行通知处理
	 */
	public void scan();
}
