package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.virtualcard.VirtualCard4Devloper;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.RemoteVirtualCardService;
import cn.com.duiba.thirdparty.dto.VirtualCardMessage;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by xiaoxuda on 2017/8/30.
 */
@RestController
public class RemoteVirtualCardServiceImpl implements RemoteVirtualCardService {
    private static Logger logger = LoggerFactory.getLogger(RemoteVirtualCardServiceImpl.class);

    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    @Autowired
    private VirtualCard4Devloper virtualCard4Devloper;

    @Override
    public DubboResult<Boolean> submitSubVirtualCard(VirtualCardMessage request, String msgTopic, String msgTag,
                                                     String msgKey) {
        try{
            validParam(request, msgTopic);
            virtualCard4Devloper.submit(request, msgTopic, msgTag, msgKey);
            return DubboResult.successResult(true);
        }catch (CodeException e){
            logger.info("提交扣虚拟卡任务失败, errMsg={}", e.getMessage());
            logger.debug("提交扣虚拟卡任务失败", e);
            return DubboResult.failResult(e.getMessage());
        }catch (Exception e){
            logger.error("提交扣虚拟卡任务失败", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    private void validParam(VirtualCardMessage request, String msgTopic){
        if(StringUtils.isBlank(msgTopic)){
            throw new CodeException(ErrorCode.E0001001.getErrorCode(), "订阅topic不能为空");
        }
        if (StringUtils.isEmpty(request.getHttpUrl())) {
            throw new CodeException(ErrorCode.E0001001.getErrorCode(), "请求URL不能为空");
        }
        if (request.getAppId() == null) {
            throw new CodeException(ErrorCode.E0001001.getErrorCode(), "APPID不能为空");
        }
        if (!httpAsyncClientPool.canSubmitToAppPool(request.getAppId())) {
            throw new CodeException(ErrorCode.E0001001.getErrorCode(), "开发者接口繁忙");
        }
    }
}
