package cn.com.duiba.service;

import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;

/**
 * Created by zzy on 2017/11/20.
 */
public class HttpClientFactory {

    /**
     * 连接超时
     */
    public static final int CONNECT_TIMEOUT = 30 * 1000;

    //从连接池中获取连接的超时时间
    public static final int DEFAULT_REQUEST_TIMEOUT = 500;

    /**
     * 长链接空闲时间
     */
    public static final int KEEPALIVE_TIMEOUT = 30 * 1000;

    /**
     * 处理超时
     */
    public static final int SOCKET_TIMEOUT = 10 * 1000;

    /**
     * 最大总连接值
     */
    public static final int MAX_CONNECT = 5000;

    /**
     * 每个路由最大连接{并发}值
     */
    public static final int MAX_ROUTE_CONNECT = 300;

    /**
     * 通知连接超时
     */
    public static final int NOTIFY_CONNECT_TIMEOUT = 10 * 1000;

    /**
     * 通知长链接空闲时间
     */
    public static final int NOTIFY_KEEPALIVE_TIMEOUT = 5 * 1000;

    /**
     * 通知长链接空闲时间
     */
    public static final int NOTIFY_SOCKET_TIMEOUT = 5 * 1000;

    public static CloseableHttpAsyncClient newCloseableHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECT_TIMEOUT).setConnectionRequestTimeout(DEFAULT_REQUEST_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(MAX_CONNECT).setMaxConnPerRoute(MAX_ROUTE_CONNECT).setKeepAliveStrategy(getKeepAliveStrategy(false)).build();
        httpClient.start();
        return httpClient;
    }

    public static CloseableHttpAsyncClient newNotifyHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(NOTIFY_CONNECT_TIMEOUT).setConnectionRequestTimeout(DEFAULT_REQUEST_TIMEOUT).setSocketTimeout(NOTIFY_SOCKET_TIMEOUT).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(MAX_CONNECT).setMaxConnPerRoute(MAX_ROUTE_CONNECT).setKeepAliveStrategy(getKeepAliveStrategy(true)).build();
        httpClient.start();
        return httpClient;
    }

    /**
     * 长连接
     *
     * @return
     */
    private static DefaultConnectionKeepAliveStrategy getKeepAliveStrategy(boolean isNotification) {
        return new DefaultConnectionKeepAliveStrategy() {
            @Override
            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1) {
                    if(isNotification){
                        return NOTIFY_KEEPALIVE_TIMEOUT;
                    }else{
                        return KEEPALIVE_TIMEOUT;
                    }
                }
                return duration;
            }
        };
    }
}