package cn.com.duiba.service;


import cn.com.duiba.crecord.message.CrecordAsyncHttp;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.nio.charset.Charset;
import java.util.List;

/**
 * Created by yansen on 17/5/5.
 */
@Component("bootRocketMqMessageListener")
public class RocketMqMessageListener implements MessageListenerConcurrently {

    private static Logger logger = LoggerFactory.getLogger(RocketMqMessageListener.class);


    @Value("${notify.topic.crecord.requset}")
    private String crecordRequest;

    @Autowired
    private CrecordAsyncHttp crecordAsyncHttp;

    /**
     * It is not recommend to throw exception,rather than returning ConsumeConcurrentlyStatus.RECONSUME_LATER if consumption failure
     *
     * @param msgs    msgs.size() >= 1<br> DefaultMQPushConsumer.consumeMessageBatchMaxSize=1,you can modify here
     * @param context
     * @return The consume status
     */
    @Override
    public ConsumeConcurrentlyStatus consumeMessage(List<org.apache.rocketmq.common.message.MessageExt> msgs, ConsumeConcurrentlyContext context) {
        try{
            //经过duiba-spring-boot-starter的内部限制，实际上msgs里只会包含一个消息，但是不排除将来可能会改为多个，而且每个消息的topic都不同
            for(MessageExt message : msgs) {
                String topic = message.getTopic();
                 if(crecordRequest.equals(topic)){
                    String body = new String(message.getBody(), Charset.forName("utf-8"));
                    crecordAsyncHttp.asyncSubmit(body);
                } else {
                     logger.warn("暂不应该有其他topic被消费");
                }
            }
        }catch(Exception e){
            logger.error(e.getMessage(),e);
            //发生异常时通常要重新消费，如果在发生特殊异常时你不希望该消息重新消费，则自行加个catch分支，并返回ConsumeConcurrentlyStatus.CONSUME_SUCCESS
            return ConsumeConcurrentlyStatus.RECONSUME_LATER;
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;    }


}
