package cn.com.duiba.biz.credits;


import cn.com.duiba.biz.tool.duiba.subcredits.SubCreditsMsgDto;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;

@Service
public class SohuzixunApi {

    private static Logger logger = LoggerFactory.getLogger(SohuzixunApi.class);

    /**
     * 兑吧在搜狐资讯的App的appkey
     */
    private static final String SOHUZIXUN_APPKEY = "VGYUMUSM5GMF7kEJkmhrPsMWXntS";

    /**
     * 兑吧在搜狐资讯的App的appsecret
     */
    private static final String SOHUZIXUN_APPSECRET = "WUwsSSNJAARLu57C1jBTTXIyDmgF";

    /**
     * 扣积分标识
     */
    private static final String CONSUME_CREDITS = "consume_credits";

    /**
     * 结果通知标识
     */
    private static final String RESULT_NOTICE = "result_notice";

    /**
     * 分隔符
     */
    private static final String DELIMITER = "?";
    /**
     * 请求类型
     */
    private static final String POSTTYPE = "postType";
    /**
     * 请求类型方式--搜狐需要post以raw串的方式请求，因公用方法是kv，故该处加上raw标识，后续请求特殊处理
     */
    private static final String RAW = "raw";

    /**
     * 构造搜狐资讯扣积分请求.
     *
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = getGateway(url);
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> creditsMap = AssembleTool.getUrlParams(urlParams);
        /** 定义参数*/
        Map<String, String> authParams = bulidParms(creditsMap, null, CONSUME_CREDITS);

        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        request.setHttpUrl(host);
        return request;
    }

    /**
     * 构造搜狐资讯扣积分请求.
     *
     * @param request
     * @return
     */
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> creditsMap = AssembleTool.getUrlParams(urlParams);
        /** 定义参数*/
        Map<String, String> authParams = bulidParms(creditsMap, null, CONSUME_CREDITS);

        request.getSubCreditsMsg().setAuthParams(authParams);
        request.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
        request.setHttpUrl(host);
        return request;
    }

    /**
     * 搜狐资讯积分商城, 获取通知请求参数
     *
     * @param notifyUrl
     * @param record
     * @return
     */
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        Map<String, String> paramsMap = bulidParms(null, record, RESULT_NOTICE);

        return AssembleTool.assembleRequest(notifyUrl, paramsMap);
    }

    /**
     * 转义搜狐资讯扣积分响应数据
     *
     * @param body
     * @return
     */
    public String parseCreditsRsp(String body) {
        try {
            JSONObject jsonBody = JSON.parseObject(body);
            JSONObject json = JsonTool.getAllJson(jsonBody);
            Map<String, String> duibaDoc = new HashMap<>();
            //0、操作成功  1、非法请求  2、用户未登录或登录已失效   3、操作失败
            String errorCode = json.getString("errorCode");
            if("0".equals(errorCode)){
                duibaDoc.put("status", "ok");
                duibaDoc.put("bizId", json.getString("bizId"));
                duibaDoc.put("credits", json.getString("number"));
            } else {
                duibaDoc.put("status", "fail");
            }
            duibaDoc.put("errorMessage", json.getString("message"));

            return JsonTool.objectToJson(duibaDoc);
        } catch (Exception e) {
            logger.error("[SohuzixunApi-parseCreditsRsp]搜狐资讯扣积分请求异常，响应解析出错:{}", e);
            return body;
        }

    }

    /**
     * 转义搜狐资讯结果通知响应
     *
     * @param body
     * @return
     */
    public String getSohuZixunResponseNotify(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
            JSONObject json = JsonTool.getAllJson(jsonBody);
            //message:失败时，返回具体消息
            //0、操作成功    1、非法请求  2、用户未登录或登录已失效   3、操作失败
            String code = json.getString("errorCode");
            if ("0".equals(code)) {
                return "ok";
            }
            return "fail";
        } catch (Exception e) {
            logger.error("[SohuzixunApi-parseCreditsRsp]搜狐资讯结果通知请求异常，响应解析出错:{}", e);
            return body;
        }
    }

    /**
     * 封装参数
     *
     * @param params
     * @return java.util.Map<java.lang.String               ,               java.lang.String>
     * @throw
     */
    private Map<String, String> bulidParms(Map<String, String> params, NotifyQueueDO record, String signLogo) {
        Map<String, String> paramsMap = Maps.newHashMap();
        if (signLogo.equals(CONSUME_CREDITS)) {
            paramsMap = splitTransfer(params.get("transfer"));
            paramsMap.put("userId", params.get("uid"));
            paramsMap.put("timestamp", String.valueOf((new Date()).getTime()));
            paramsMap.put("addCoin", "-" + params.get("credits"));
            paramsMap.put("orderId", params.get("orderNum"));

        } else if (signLogo.equals(RESULT_NOTICE)) {
            paramsMap = splitTransfer(record.getTransfer());
            paramsMap.put("userId", String.valueOf(record.getPartnerUserId()));
            paramsMap.put("timestamp", String.valueOf((new Date()).getTime()));
            paramsMap.put("orderId", record.getDuibaOrderNum());
            String auditResult = "0";
            if (record.getResult()) {
                auditResult = "1";
            }
            paramsMap.put("auditResult", auditResult);
        }
        paramsMap.put("appKey", SOHUZIXUN_APPKEY);
        paramsMap.put("appSecret", SOHUZIXUN_APPSECRET);
        paramsMap.put("sign", SignTool.sign(paramsMap));

        paramsMap.remove("appSecret");
        //放入请求类型标识
        paramsMap.put(POSTTYPE,RAW);

        return paramsMap;
    }


    /**
     * 获取接口网关
     *
     * @param url
     * @return java.lang.String
     * @throw
     */
    @Nullable
    private String getGateway(String url) {
        if (StringUtils.isNotBlank(url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                return url.substring(0, index);
            }
        }
        return url;
    }

    private Map<String,String> splitTransfer(String transfer){
        //transfer参数样例  transfer=token%3D8b6656c1d09287c6160a8aca2ef1d63f%26did%3D66510e33-cd94-3852-ae70-2a8ecb24d32a%26appName%3D2
        Map<String,String> paramsMap = Maps.newHashMap();
        String toParams = null;
        try {
            toParams = URLDecoder.decode(transfer, "utf-8");
        } catch (UnsupportedEncodingException e) {
            logger.error("sohuTransferURLDecoder.decode error:" + transfer, e);
        }
        String[] transfers = toParams.split("&");
        for (int i = 0; i < transfers.length; i++) {
            String[] p = transfers[i].split("=");
            if (p.length != 2) {
                continue;
            }
            String key = p[0];
            String value = p[1];
            paramsMap.put(key, value);
        }
        return paramsMap;
    }

}
