package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.tool.duiba.subcredits.SubCreditsMsgDto;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.ErrorCode;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @ClassName: YoukuApi
 * @Description: 优酷定制
 * @author: fxr
 * @date: 2018/4/19 10:30
 * @version: V1.0.0
 */
@Service
public class YoukuApi {

    private static Logger logger = LoggerFactory.getLogger(YoukuApi.class);

    /**
     * 兑吧在优酷的App的appkey
     */
    public static final String YOUKU_APPKEY = "kgc9ebdZeg5PpXq9";

    /**
     * 兑吧在优酷的App的appsecret
     */
    public static final String YOUKU_APPSECRET = "kjnmcdmdephhealfkakijdnojekfhihg";

    /**
     * 扣积分action
     */
    public static final String YOUKU_ACTION_POINT = "youku.duiba.mall.consume.point";

    /**
     * 用户兑换结果通知action
     */
    public static final String YOUKU_ACTION_NOTICE = "youku.duiba.mall.exchange.result.notice";

    /**
     * 兑换虚拟权益
     */
    public static final String YOUKU_ACTION_VIRTUAL = "youku.duiba.mall.send.right";

    /**
     * version
     */
    public static final String YOUKU_VERSION = "3.0";

    /**
     * sign_method
     */
    public static final String YOUKU_SIGN_METHOD = "md5";

    /**
     * 分隔符
     */
    private static final String DELIMITER = "?";

    /**
     * 构造优酷扣积分请求.
     *
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = getGateway(url);
        //  请求参数
        Map<String, String> params = request.getAuthParams();

        //  自定义 业务参数
        TreeMap authParams = new TreeMap();
        authParams.put("type", params.get("type"));
        authParams.put("uid", params.get("uid"));
        authParams.put("credits", params.get("credits"));
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("type", params.get("type"));
        authParams.put("description", params.get("description"));
        authParams.put("actualPrice", params.get("actualPrice"));
        authParams.put("ip", params.get("ip"));
        authParams.put("time", String.valueOf(new Date().getTime() / 1000));

        if (StringUtils.isNotBlank(params.get("itemCode"))) {
            authParams.put("itemCode", params.get("itemCode"));
        }

        // 获取签名信息后，去掉参数中的系统参数
        authParams = getSign(authParams, YOUKU_ACTION_POINT);

        request.setHttpType(CreditsMessage.HTTP_GET);
        request.setHttpUrl(AssembleTool.assembleUrl(host, authParams));
        return request;
    }

    /**
     * 优酷积分商城, 用户兑换结果通知
     *
     * @param record
     * @return
     */
    public HttpRequestBase getRequestNotify(String url, NotifyQueueDO record) {

        // 拼接业务参数
        TreeMap authParams = new TreeMap<>();
        authParams.put("success", String.valueOf(record.getResult()));
        authParams.put("uid", record.getPartnerUserId());
        authParams.put("orderNum", record.getDuibaOrderNum());
        /**
         *  "errorMessage"属性为null的传值，签名时会发生空指针异常，空字符串时会发生UnsupportedEncodingException异常；
         *  当兑换成功的时候，即record.getError4developer()取值为null或空字符串时，不传参数："errorMessage"
         */
        if (!record.getResult()) {
            authParams.put("errorMessage", StringUtils.isBlank(record.getError4developer()) ? "未知原因" : record.getError4developer());
        }
        // 获取签名信息后，去掉参数中的系统参数
        authParams = getSign(authParams, YOUKU_ACTION_NOTICE);

        return new HttpPost(AssembleTool.assembleUrl(url, authParams));
    }

    /**
     * 转义优酷街扣积分响应数据
     *
     * @param body
     * @return
     */
    public String parseCreditsRsp(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            //暂时屏蔽到youku的返回结果为html格式错误，玉东已经在让对方的开发查原因，但对方还没有查明具体原因
            logger.info("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        Map<String, String> duibaDoc = new HashMap<>();
        duibaDoc.put("errorMessage", json.getString("errorMessage"));
        duibaDoc.put("status", json.getString("status"));
        duibaDoc.put("bizId", json.getString("traceId"));
        duibaDoc.put("credits", json.getString("credits"));
        return JsonTool.objectToJson(duibaDoc);
    }


    /**
     * @param params 需加密的参数，TreeMap保证参数按升序排序，
     *               非Java语言需要先按参数名进行排序，系统参数与业务参数相同的情况下，系统参数在前
     * @return 返回请求openapi所需参数，
     * 1、GET请求，直接遍历Map，拼接k-v即可；
     * 2、POST请求，迭代Map，封装为NameValuePair即可
     */
    public static TreeMap getSign(TreeMap params, String action) {

        //  自定义 系统参数
        params.put("action", action);
        params.put("client_id", YOUKU_APPKEY);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000));
        params.put("version", YOUKU_VERSION);
        params.put("sign_method", YOUKU_SIGN_METHOD);

        /** 用于存放与业务参数名相同的系统参数*/
        StringBuffer signString = new StringBuffer();
        try {
            /** 生成签名字符串*/
            Iterator titer = params.entrySet().iterator();
            while (titer.hasNext()) {
                Map.Entry<String, String> entry = (Map.Entry) titer.next();
                signString.append(entry.getKey());
                signString.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        } catch (Exception e) {
            logger.error("YoukuApi getSign error:", "签名字符串拼接错误：" + e.getMessage() + "，请检查参数是否正确！");
        }
        String sign;
        signString.append(YOUKU_APPSECRET);
        try {
            sign = md5Sign(signString.toString());
        } catch (Exception e) {
            params.put("error", ErrorCode.E9999999.getErrorCode());
            return params;
        }
        return packageRequestParams(params, sign);
    }

    /**
     * 拼接请求参数，返回Map方便post请求封装请求参数
     *
     * @param params 业务参数
     * @param sign   加密字符串
     * @return
     */
    private static TreeMap packageRequestParams(TreeMap params, String sign) {
        StringBuffer buffer = new StringBuffer();

        /**  拼接系统参数*/
        buffer.append("{");
        buffer.append("\"client_id\":");
        buffer.append("\"");
        buffer.append(params.get("client_id"));
        buffer.append("\",");
        buffer.append("\"timestamp\":");
        buffer.append("\"");
        buffer.append(params.get("timestamp"));
        buffer.append("\",");
        buffer.append("\"version\":");
        buffer.append("\"");
        buffer.append(params.get("version"));
        buffer.append("\",");
        buffer.append("\"sign_method\":");
        buffer.append("\"");
        buffer.append(params.get("sign_method"));
        buffer.append("\",");
        buffer.append("\"sign\":");
        buffer.append("\"");
        buffer.append(sign);
        buffer.append("\",");
        buffer.append("\"action\":");
        buffer.append("\"");
        buffer.append(params.get("action"));
        buffer.append("\"");
        buffer.append("}");

        params.put("opensysparams", buffer.toString());

        /** 移除系统参数 */
        params.remove("client_id");
        params.remove("timestamp");
        params.remove("version");
        params.remove("sign_method");
        params.remove("action");


        return params;
    }

    /**
     * MD5加密
     *
     * @param signString 待加密字符串
     * @return java.lang.String
     * @throw
     */
    private static String md5Sign(String signString) {
        return DigestUtils.md5Hex(signString);
    }

    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper request) {

        String url = request.getHttpUrl();
        String host = getGateway(url);
        //  请求参数
        Map<String, String> params = request.getSubCreditsMsg().getAuthParams();

        //  自定义 业务参数
        TreeMap authParams = new TreeMap();
        authParams.put("type", params.get("type"));
        authParams.put("uid", params.get("uid"));
        authParams.put("credits", params.get("credits"));
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("type", params.get("type"));
        authParams.put("description", params.get("description"));
        authParams.put("actualPrice", params.get("actualPrice"));
        authParams.put("ip", params.get("ip"));
        authParams.put("time", String.valueOf(System.currentTimeMillis() / 1000));

        if (StringUtils.isNotBlank(params.get("itemCode"))) {
            authParams.put("itemCode", params.get("itemCode"));
        }

        // 获取签名信息后，去掉参数中的系统参数
        authParams = getSign(authParams, YOUKU_ACTION_POINT);

        request.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_GET);
        request.setHttpUrl(AssembleTool.assembleUrl(host, authParams));
        return request;
    }

    /**
     * 构造优酷虚拟权益兑换请求.
     *
     * @param request
     * @return
     */
    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        //  解析URL
        List<String> analysisList = analysisUrl(url);
        if (analysisList.isEmpty()) {
            return request;
        }
        //  优酷网关地址
        String host = analysisList.get(0);
        //  请求参数
        Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));
        //  自定义 业务参数
        TreeMap authParams = new TreeMap();
        authParams.put("uid", params.get("uid"));
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("ip", params.get("ip"));
        authParams.put("rightEname", params.get("params"));
        // 获取签名信息后，去掉参数中的系统参数
        authParams = getSign(authParams, YOUKU_ACTION_VIRTUAL);
        request.setHttpUrl(AssembleTool.assembleUrl(host, authParams));
        return request;
    }

    /**
     * 转义优酷虚拟权益兑换响应.
     *
     * @param body
     * @return
     */
    public String getVirtualRespone(String body) {
        JSONObject jsonBody;
        Map<String, String> duibaDoc = new HashMap<>();
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            logger.warn("[YoukuApi-getVirtualRespone]优酷响应JSON解析错误:"+e.getMessage()+",优酷接口原响应为："+body);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "优酷响应JSON解析错误");
            return JsonTool.objectToJson(duibaDoc);
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);

        String errno = json.getString("errno");

        if (StringUtils.isBlank(errno)) {
            logger.info("[YoukuApi-getVirtualRespone]优酷响应状态码为空,优酷接口原响应为："+body);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "优酷接口状态码为空");
            return JsonTool.objectToJson(duibaDoc);
        }
        if (errno.equals("0")) {
            duibaDoc.put("status", "success");
            duibaDoc.put("supplierBizId", json.getString("traceId"));
        }else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("supplierBizId", json.getString("traceId"));
            duibaDoc.put("errorMessage", json.getString("errmsg"));
        }

        return JsonTool.objectToJson(duibaDoc);
    }


    /**
     * 获取接口网关
     *
     * @param url
     * @return java.lang.String
     * @throw
     */
    @Nullable
    private static String getGateway(String url) {
        if (StringUtils.isNotBlank(url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                return url.substring(0, index);
            }
        }
        return url;
    }

    /**
     * 解析URL，获取网关地址和参数串
     *
     * @param url
     * @return java.lang.String
     * @throw
     */
    private static List<String> analysisUrl(String url) {
        List<String> analysisList = Lists.newArrayList();
        if (StringUtils.isNotBlank(url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                analysisList.add(url.substring(0, index));
                analysisList.add(url.substring(index + 1, url.length()));
            }else {
                analysisList.add(url);
                analysisList.add("");
            }
        }
        return analysisList;
    }
}
