package cn.com.duiba.biz.virtualcard;

import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.thirdparty.dto.VirtualCardCallbackMessage;
import cn.com.duiba.thirdparty.dto.VirtualCardMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by xiaoxuda on 2017/8/30.
 */
@Component
public class VirtualCard4Devloper {
    private static Logger logger = LoggerFactory.getLogger(VirtualCard4Devloper.class);

    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;

    /**
     * 提交扣虚拟卡HTTP请求
     * @param request
     * @param msgTopic
     * @param msgTag
     * @param msgKey
     */
    public void submit(final VirtualCardMessage request, final String msgTopic, final String msgTag, final String msgKey) {
        HttpRequestBase http;
        if (VirtualCardMessage.HTTP_POST.equals(request.getHttpType())) {
            http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
            HttpRequestLog.logUrl("[action subVirtualCard] [tag request] [bizId " + request.getRelationId() + "] " +
                    "[type " + request.getRelationType() + "] [http_method post] [url " + request.getHttpUrl() + "] " +
                    "[authParams "+request.getAuthParams()+"]");
        } else {
            http = new HttpGet(AssembleTool.assembleUrl(request.getHttpUrl(), request.getAuthParams()));
            HttpRequestLog.logUrl("[action subVirtualCard] [tag request] [bizId " + request.getRelationId() + "] " +
                    "[type " + request.getRelationType() + "] [http_method get] [url " + request.getHttpUrl() + "]");
        }
        httpAsyncClientPool.submit(request.getAppId(), http, new FutureCallback<HttpResponse>() {

            @Override
            public void completed(HttpResponse response) {
                VirtualCardCallbackMessage resp = new VirtualCardCallbackMessage(request);
                try {
                    resp.setCallbackType(VirtualCardCallbackMessage.CALLBACK_TYPE_COMPLETED);
                    resp.setMessage(EntityUtils.toString(response.getEntity()));
                } catch (Exception e) {
                    logger.error("toDeveloper completed", e);
                } finally {
                    finallyBlock(resp, msgTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
                }
            }

            @Override
            public void failed(Exception ex) {
                logger.error("toDeveloper failed bizId:{},bizType={}", request.getRelationId(),
                        request.getRelationType(), ex);

                VirtualCardCallbackMessage resp = new VirtualCardCallbackMessage(request);
                try {
                    resp.setCallbackType(VirtualCardCallbackMessage.CALLBACK_TYPE_FAILED);
                    resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
                } catch (Exception e) {
                    logger.error("toDeveloper failed", e);
                } finally {
                    finallyBlock(resp, msgTopic, msgTag, msgKey, "");
                }
            }

            @Override
            public void cancelled() {
                VirtualCardCallbackMessage resp = new VirtualCardCallbackMessage(request);
                try {
                    resp.setCallbackType(VirtualCardCallbackMessage.CALLBACK_TYPE_FAILED);
                    resp.setMessage("http cancelled");
                } catch (Exception e) {
                    logger.error("toDeveloper cancelled", e);
                } finally {
                    finallyBlock(resp, msgTopic, msgTag, msgKey, "");
                }
            }

        });
    }

    /**
     * 返回响应结果到业务放
     * @param resp
     * @param msgTopic
     * @param msgTag
     * @param msgKey
     */
    private void finallyBlock(VirtualCardCallbackMessage resp, String msgTopic, String msgTag, String msgKey, String code) {
        try {
            String body = JsonTool.objectToJson(resp);
            if(msgTopic.contains("MQ")){
                rocketMQMsgProducer.sendMsg(msgTopic, msgTag, msgKey, body,false,null);
            }else{
                messageService.sendMsg(msgTopic,msgTag,msgKey,body);
            }
        } catch (Exception e) {
            logger.error("toDeveloper failed bizId:{},bizType={}", resp.getRelationId(),  resp.getRelationType(), e);
        } finally {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [code "+code+"] " +
                    "[bizId " + resp.getRelationId() + "] [type " + resp.getRelationType() + "] " +
                    "[callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
        }
    }
}
