package cn.com.duiba.domain;

import cn.com.duiba.biz.tool.duiba.subcredits.SubCreditsMsgDto;
import cn.com.duiba.tool.AssembleTool;

import java.io.Serializable;
import java.util.Map;

public class SubCreditsMsgWrapper implements Serializable {
    private static final long serialVersionUID = 8881708375543730967L;
    /**
     * 扣积分消息
     */
    private SubCreditsMsgDto subCreditsMsg;
    /**
     * 最终请求url
     */
    private String httpUrl;

    public SubCreditsMsgWrapper(SubCreditsMsgDto subCreditsMsg) {
        this.subCreditsMsg = subCreditsMsg;
        Map<String, String> map = subCreditsMsg.getCreditConsumeParams().toRequestMap(subCreditsMsg.getAppSecret());
        this.httpUrl = AssembleTool.assembleUrl(subCreditsMsg.getCreditsConsumeRequestUrl(), map);
    }

    public SubCreditsMsgDto getSubCreditsMsg() {
        return subCreditsMsg;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }
}
