package cn.com.duiba.service.impl;

import cn.com.duiba.service.DingService;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.ErrorCode;
import com.dingHelper.auth.AuthHelper;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.CorpMessageCorpconversationAsyncsendRequest;
import com.dingtalk.api.response.CorpMessageCorpconversationAsyncsendResponse;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.taobao.api.ApiException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Service
public class DingServiceImpl implements DingService {

    private static Cache<String, String> cache = CacheBuilder.newBuilder().expireAfterWrite(5, TimeUnit.MINUTES).build();

    @Value("${ding.app.secret}")
    private String secret;

    @Value("${ding.app.appId}")
    private String appId;

    @Value("${ding.app.agentId}")
    private String dingAgentId;

    @Value("${ding.app.restApi}")
    private String dingRestAPi;

    @Autowired
    private RemoteAdminService remoteAdminService;

    @Override
    public void sendPersonalDingTextMsgByEmail(List<String> emails, String text) {
        //根据用户邮箱去sso那边获取钉钉id，后期应该考虑让sso提供批量接口
        List<String> dingUserIds = Lists.newArrayList();
        emails.forEach( email -> {
            AdminDto adminDto = remoteAdminService.findByEmail(email);
            if (adminDto != null && StringUtils.isNotEmpty(adminDto.getDingUserId())) {
                dingUserIds.add(adminDto.getDingUserId());
            }
        });
        this.sendDingTextMsg(dingUserIds, text);
    }

    @Override
    public void sendPersonalDingTextMsgByDingId(List<String> dingIds, String text) {
        this.sendDingTextMsg(dingIds, text);
    }

    /**
     * 发送文本消息到钉钉个人
     * @param dingUserIds 钉钉用户id列表
     * @param text 文本消息
     * @return
     */
    public boolean sendDingTextMsg(List<String> dingUserIds, String text){
        String userIds = String.join(",", dingUserIds);
        CorpMessageCorpconversationAsyncsendRequest req = new CorpMessageCorpconversationAsyncsendRequest();
        req.setMsgtype("text");
        req.setAgentId(Long.valueOf(dingAgentId));
        req.setUseridList(userIds);
        req.setToAllUser(false);
        req.setMsgcontent("{\"content\": \"" + text +  "\"}");
        return getResult(req);
    }

    private boolean getResult(CorpMessageCorpconversationAsyncsendRequest req) {
        DingTalkClient client = new DefaultDingTalkClient(dingRestAPi);
        try {
            CorpMessageCorpconversationAsyncsendResponse rsp = client.execute(req, this.getAccessToken());
            if (rsp == null) {
                throw new RuntimeException("send" + req.getMsgcontent() + " , result: null");
            }
            return rsp.getResult().getSuccess();
        } catch (ApiException e) {
            throw new CodeException(ErrorCode.E9999999, e);
        }
    }

    private String getAccessToken() {
        final String cacheKey = "Access_Token";
        try {
            return cache.get(cacheKey, () -> AuthHelper.getAccessToken(appId,secret));
        } catch (ExecutionException e) {
            throw new CodeException(ErrorCode.E9999999, e);
        }
    }
}
