package cn.com.duiba.tool;

import cn.com.duiba.boot.perftest.PerfTestContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 请求日志
 */
public class HttpRequestLog {

	public static final Logger log = LoggerFactory.getLogger(HttpRequestLog.class);

	private HttpRequestLog() {

	}

	/**
	 * 记录请求日志
	 * 
	 * @param url
	 */
	public static void logUrl(String url) {
		if(!PerfTestContext.isCurrentInPerfTestMode()){
			log.info(url);
		}
	}

	/**
	 * 截取返回内容
	 * 
	 * @param parm
	 * @return
	 */
	public static String subBody(String parm) {
		try {
			String body = parm;
			if (StringUtils.isNotBlank(body) && body.length() > 2000) {
				body = body.substring(0, 2000);
			}
			return body;
		} catch (Exception e) {
			log.error("subBody", e);
			return parm;
		}
	}

}
