package cn.com.duiba.tool;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.ObjectMapper;

import java.util.Map;

/**
 * JSON转换工具类
 */
public class JsonTool {

	private static Logger log = LoggerFactory.getLogger(JsonTool.class);

	private JsonTool() {
	}

	/**
	 * 对象转JSON
	 * 
	 * @param object
	 * @return
	 */
	public static String objectToJson(Object object) {
		String json = null;
		try {
			ObjectMapper mapper = new ObjectMapper();
			json = mapper.writeValueAsString(object);
		} catch (Exception e) {
			log.error("objectToJson", e);
		}
		return json;
	}

	/**
	 * JSON字符串转对象
	 * 
	 * @param json
	 * @param clazz
	 * @return
	 */
	public static <T> T jsonToObject(String json, Class<T> clazz) {
		try {
			ObjectMapper mapper = new ObjectMapper();
			return mapper.readValue(json, clazz);
		} catch (Exception e) {
			log.error("jsonToObject", e);
		}
		return null;
	}


	/**
	 * 将所有的子JSON转换为一级JSON方便快速取值
	 *
	 * @param o
	 * @return
	 */
	public static JSONObject getAllJson(JSONObject o) {
		JSONObject json = new JSONObject();
		for (Map.Entry<String, Object> entry : o.entrySet()) {
			if (entry.getValue() instanceof JSONObject) {
				JSONObject child = (JSONObject) entry.getValue();
				for (Map.Entry<String, Object> chileEntry : child.entrySet()) {
					json.put(chileEntry.getKey(), chileEntry.getValue());
				}
			} else {
				json.put(entry.getKey(), entry.getValue());
			}
		}
		JSONObject ret = new JSONObject();
		for (Map.Entry<String, Object> entry : json.entrySet()) {
			if (entry.getValue() instanceof JSONObject) {
				JSONObject child = (JSONObject) entry.getValue();
				for (Map.Entry<String, Object> chileEntry : child.entrySet()) {
					ret.put(chileEntry.getKey(), chileEntry.getValue());
				}
			} else {
				ret.put(entry.getKey(), entry.getValue());
			}
		}
		return ret;
	}
}
