/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.alipay.supplier;

import cn.com.duiba.biz.alipay.dao.AlipayBatchLogDAO;
import cn.com.duiba.biz.alipay.domain.AlipayBatchLogDO;
import cn.com.duiba.biz.alipay.domain.AlipayOfficialRequest;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.ErrorCode;
import cn.com.duiba.tool.HttpRequestLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class AlipayBatchExecutor
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(AlipayBatchExecutor.class);
    @Value(value="${supplier.supply.alipay.url}")
    private String requestUrl;
    @Value(value="${supplier.supply.alipay.batchNotifyUrl}")
    private String batchNotifyUrl;
    @Value(value="${supplier.supply.alipay.account}")
    private String account;
    @Value(value="${supplier.supply.tawalipay.batchNotifyUrl}")
    private String tawBatchNotifyUrl;
    @Value(value="${supplier.supply.alipay.md5Key}")
    private String md5Key;
    @Value(value="${supplier.supply.alipay.partner}")
    private String partner;
    private Integer batchCount = 100;
    private static final String ACCOUNT_NAME = "\u676d\u5dde\u5151\u5427\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8";
    private static final String CHART_SET = "utf-8";
    @Autowired
    private AlipayBatchLogDAO alipayBatchLogDAO;
    @Autowired
    private MessageService messageService;
    @Resource
    private ScheduledExecutorService scheduler;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    private LinkedBlockingQueue<AlipayOfficialRequest> queue = new LinkedBlockingQueue();

    public Integer getQueueSize() {
        return this.queue.size();
    }

    public Map<String, Object> dumpDetail() {
        HashMap<String, AlipayOfficialRequest> maps = new HashMap<String, AlipayOfficialRequest>();
        for (AlipayOfficialRequest request : this.queue) {
            maps.put(request.getOrderNum(), request);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("runningStat", maps);
        return map;
    }

    public void afterPropertiesSet() throws Exception {
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    AlipayBatchExecutor.this.innerRun();
                }
                catch (Exception e) {
                    log.error("AlipayBatchExecutor scheduleWithFixedDelay error", (Throwable)e);
                }
            }
        }, 3L, 3L, TimeUnit.SECONDS);
        log.info("AlipayBatchExecutor schedule started");
    }

    public void innerRun() {
        ArrayList<AlipayOfficialRequest> list = new ArrayList<AlipayOfficialRequest>();
        for (int i = 0; i < this.batchCount && !this.queue.isEmpty(); ++i) {
            AlipayOfficialRequest req = this.queue.poll();
            if (req == null) continue;
            list.add(req);
        }
        if (!list.isEmpty()) {
            SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHHmmss");
            AlipayBatchLogDO blog = new AlipayBatchLogDO(true);
            this.alipayBatchLogDAO.insert(blog);
            String batchNo = f.format(new Date()) + blog.getId();
            ArrayList<String> orderNums = new ArrayList<String>();
            for (AlipayOfficialRequest req : list) {
                orderNums.add(req.getOrderNum());
            }
            this.postRequest(list, blog, batchNo, orderNums);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRequest(List<AlipayOfficialRequest> list, AlipayBatchLogDO blog, String batchNo, List<String> orderNums) {
        String url = this.generateUrl(batchNo, list);
        String body = "";
        CloseableHttpResponse response = null;
        try {
            HttpPost post = this.generatePostRequest(batchNo, list);
            post.setConfig(this.getTimeoutConfig());
            HttpRequestLog.logUrl("[action alipay] [tag request] [url " + url + "]");
            response = this.httpClient.execute((HttpUriRequest)post);
            body = EntityUtils.toString((HttpEntity)response.getEntity());
            HttpRequestLog.logUrl("[action alipay] [tag response] [body " + body + "]");
        }
        catch (Exception e) {
            log.error("scheduler httpclient error", (Throwable)e);
        }
        finally {
            try {
                AlipayBatchLogDO ablog = new AlipayBatchLogDO(blog.getId());
                ablog.setBatchNo(batchNo);
                ablog.setAllOrderNums(orderNums);
                ablog.setRequestUrl(url);
                ablog.setResponse(body);
                this.alipayBatchLogDAO.update(ablog);
            }
            catch (Exception e) {
                log.error("scheduler update log error", (Throwable)e);
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception e) {
                    log.error("close CloseableHttpResponse error", (Throwable)e);
                }
            }
        }
    }

    private RequestConfig getTimeoutConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }

    public void addAlipayOrder(AlipayOfficialRequest req) {
        if (!this.messageService.messageUniqueCheck(req.getOrderNum(), "alipay")) {
            return;
        }
        this.queue.add(req);
        HttpRequestLog.logUrl("[action alipay] [tag request] [bizId " + req.getOrderNum() + "] [url submit in batch queue]");
    }

    private HttpPost generatePostRequest(String batchNo, List<AlipayOfficialRequest> list) {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String payDate = format.format(now);
        StringBuilder detailDataStr = new StringBuilder("");
        Integer fee = 0;
        for (AlipayOfficialRequest req : list) {
            String no = req.getOrderNum();
            String alipay = req.getAlipay();
            String realname = req.getRealname();
            String price = req.getQuantity() + "";
            fee = fee + req.getQuantity();
            String memo = req.getMemo();
            detailDataStr.append(no).append("^").append(alipay).append("^").append(realname).append("^").append(price).append("^").append(memo).append("|");
        }
        String detailData = detailDataStr.toString();
        if (detailData.endsWith("|")) {
            detailData = detailData.substring(0, detailData.length() - 1);
        }
        String batchFee = fee.toString();
        String batchNum = Integer.toString(list.size());
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "batch_trans_notify_no_pwd");
        sParaTemp.put("partner", this.partner);
        sParaTemp.put("_input_charset", CHART_SET);
        sParaTemp.put("notify_url", this.tawBatchNotifyUrl);
        sParaTemp.put("email", this.account);
        sParaTemp.put("account_name", ACCOUNT_NAME);
        sParaTemp.put("pay_date", payDate);
        sParaTemp.put("batch_no", batchNo);
        sParaTemp.put("batch_fee", batchFee);
        sParaTemp.put("batch_num", batchNum);
        sParaTemp.put("detail_data", detailData);
        ArrayList keys = new ArrayList(sParaTemp.keySet());
        Collections.sort(keys);
        StringBuilder stringBf = new StringBuilder("");
        for (String s : keys) {
            if (stringBf.toString().length() == 0) {
                stringBf.append(s).append("=").append((String)sParaTemp.get(s));
                continue;
            }
            stringBf.append("&").append(s).append("=").append((String)sParaTemp.get(s));
        }
        stringBf.append(this.md5Key);
        String string = stringBf.toString();
        String sign = "";
        try {
            sign = AlipayBatchExecutor.toHexValue(AlipayBatchExecutor.encryptMD5(string.getBytes(Charset.forName(CHART_SET))));
        }
        catch (Exception e) {
            log.error("toHexValue", (Throwable)e);
        }
        sParaTemp.put("sign", sign);
        sParaTemp.put("sign_type", "MD5");
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(sParaTemp.size());
        for (Map.Entry entry : sParaTemp.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair((String)entry.getKey(), value));
        }
        String url = this.requestUrl;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        HttpPost post = new HttpPost(url + "_input_charset=utf-8");
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName(CHART_SET)));
        post.addHeader("Content-Type", "application/x-www-form-urlencoded; text/html; charset=utf-8");
        return post;
    }

    private String generateUrl(String batchNo, List<AlipayOfficialRequest> list) {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String payDate = format.format(now);
        StringBuilder detailBf = new StringBuilder("");
        Integer fee = 0;
        for (AlipayOfficialRequest req : list) {
            String no = req.getOrderNum();
            String alipay = req.getAlipay();
            String realname = req.getRealname();
            String price = req.getQuantity() + "";
            fee = fee + req.getQuantity();
            String memo = req.getMemo();
            detailBf.append(no).append("^").append(alipay).append("^").append(realname).append("^").append(price).append("^").append(memo).append("|");
        }
        String detailData = detailBf.toString();
        if (detailData.endsWith("|")) {
            detailData = detailData.substring(0, detailData.length() - 1);
        }
        String batchFee = fee.toString();
        String batchNum = Integer.toString(list.size());
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "batch_trans_notify_no_pwd");
        sParaTemp.put("partner", this.partner);
        sParaTemp.put("_input_charset", CHART_SET);
        sParaTemp.put("notify_url", this.batchNotifyUrl);
        sParaTemp.put("email", this.account);
        sParaTemp.put("account_name", ACCOUNT_NAME);
        sParaTemp.put("pay_date", payDate);
        sParaTemp.put("batch_no", batchNo);
        sParaTemp.put("batch_fee", batchFee);
        sParaTemp.put("batch_num", batchNum);
        sParaTemp.put("detail_data", detailData);
        ArrayList keys = new ArrayList(sParaTemp.keySet());
        Collections.sort(keys);
        StringBuilder string = new StringBuilder();
        for (String s : keys) {
            if (string.length() == 0) {
                string.append(s).append("=").append((String)sParaTemp.get(s));
                continue;
            }
            string.append("&").append(s).append("=").append((String)sParaTemp.get(s));
        }
        string.append(this.md5Key);
        String sign = "";
        try {
            sign = AlipayBatchExecutor.toHexValue(AlipayBatchExecutor.encryptMD5(string.toString().getBytes(Charset.forName(CHART_SET))));
        }
        catch (Exception e) {
            log.error("encryptMD5", (Throwable)e);
        }
        sParaTemp.put("sign", sign);
        sParaTemp.put("sign_type", "MD5");
        return AlipayBatchExecutor.assembleUrl(this.requestUrl, sParaTemp);
    }

    private static String assembleUrl(String url, Map<String, String> params) {
        StringBuilder str = new StringBuilder(url);
        str.append("?");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().length() == 0) {
                    str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), CHART_SET)).append("&");
            }
            catch (UnsupportedEncodingException e) {
                log.error("assembleUrl", (Throwable)e);
            }
        }
        return str.toString();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    private static byte[] encryptMD5(byte[] data) throws CodeException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(data);
            return md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("encryptMD5", (Throwable)e);
            throw new CodeException(ErrorCode.E9999999);
        }
    }

    public void setMd5Key(String md5Key) {
        this.md5Key = md5Key;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setBatchNotifyUrl(String batchNotifyUrl) {
        this.batchNotifyUrl = batchNotifyUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public void setPartner(String partner) {
        this.partner = partner;
    }

    public void setBatchCount(Integer batchCount) {
        this.batchCount = batchCount;
    }
}

