/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.credits.AddCreditsToDeveloper;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.service.HttpAsyncClientPool;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AddCreditsRetryJob
extends AbstractSimpleElasticJob {
    private Logger log = LoggerFactory.getLogger(AddCreditsRetryJob.class);
    Cache<Long, AtomicLong> cache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
    @Value(value="${notifycenter.timer.enable}")
    private boolean timerEnable;
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private AddCreditsToDeveloper addCreditsToDeveloper;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    public void process(JobExecutionMultipleShardingContext shardingContext) {
        if (!this.timerEnable) {
            return;
        }
        long s = System.currentTimeMillis();
        List<HttpMessageDO> dos = this.httpMessageDAO.findNeedRetry("addCredits", 2000);
        for (HttpMessageDO httpMessageDO : dos) {
            if (httpMessageDO == null || httpMessageDO.getAppId() == null) continue;
            if (this.httpAsyncClientPool.canSubmitToAppPool(httpMessageDO.getAppId().toString())) {
                this.addCreditsToDeveloper.submit(httpMessageDO);
                continue;
            }
            AtomicLong addCache = (AtomicLong)this.cache.getIfPresent((Object)httpMessageDO.getAppId());
            if (addCache == null) {
                this.cache.put((Object)httpMessageDO.getAppId(), (Object)new AtomicLong(1L));
                continue;
            }
            addCache.incrementAndGet();
        }
        if (this.cache.size() > 0L) {
            for (Map.Entry entry : this.cache.asMap().entrySet()) {
                this.log.warn("scan cannot be submit to queue, appId:{}, times:{}", entry.getKey(), (Object)((AtomicLong)entry.getValue()).get());
            }
        }
        long e = System.currentTimeMillis();
        this.log.debug("addCredits scan size:{} time:{} ms", (Object)dos.size(), (Object)(e - s));
    }
}

