/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FengJinApi {
    private static Logger log = LoggerFactory.getLogger(FengJinApi.class);
    @Autowired
    private AppDAO appDAO;

    public CreditsMessage getSubCreditsMessage(CreditsMessage creditsMessage) {
        String url = this.getFengJinGetUrl(creditsMessage.getHttpUrl());
        creditsMessage.setHttpUrl(url);
        creditsMessage.setHttpType("get");
        creditsMessage.setAuthParams(new HashMap());
        return creditsMessage;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper creditsMessage) {
        String url = this.getFengJinGetUrl(creditsMessage.getHttpUrl());
        creditsMessage.setHttpUrl(url);
        creditsMessage.getSubCreditsMsg().setHttpType(1);
        creditsMessage.getSubCreditsMsg().setAuthParams(new HashMap());
        return creditsMessage;
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO appDO) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (record.getResult() != null) {
            params.put("success", String.valueOf(record.getResult()));
        }
        if (StringUtils.isNotEmpty((String)record.getError4developer())) {
            params.put("errorMessage", record.getError4developer());
        }
        if (StringUtils.isNotEmpty((String)record.getDeveloperBizId())) {
            params.put("bizId", record.getDeveloperBizId());
        }
        params.put("appKey", appDO.getAppKey());
        params.put("appSecret", this.appDAO.getAppSecret(appDO));
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        if (StringUtils.isNotEmpty((String)record.getPartnerUserId())) {
            params.put("uid", record.getPartnerUserId());
        }
        params.put("orderNum", record.getDuibaOrderNum());
        String sign = SignTool.sign(params);
        params.remove("appSecret");
        params.put("sign", sign);
        if (StringUtils.isNotBlank((String)record.getPartnerUserId())) {
            notifyUrl = notifyUrl.endsWith("/") ? notifyUrl + record.getPartnerUserId() : notifyUrl + "/" + record.getPartnerUserId();
        }
        return new HttpGet(AssembleTool.assembleUrl(notifyUrl, params));
    }

    private String getFengJinGetUrl(String url) {
        try {
            String[] arr = url.split("[?]");
            String newUrl = arr[0];
            if (arr.length < 2) {
                return newUrl;
            }
            List<String> paramList = Arrays.asList(arr[1].split("[&]"));
            for (String value : paramList) {
                if (!StringUtils.isNotBlank((String)value) || !value.trim().startsWith("uid=")) continue;
                String uid = value.replace("uid=", "");
                if (StringUtils.isBlank((String)uid)) break;
                if (newUrl.endsWith("/")) {
                    newUrl = newUrl + URLDecoder.decode(uid, "utf-8");
                    break;
                }
                newUrl = newUrl + "/" + URLDecoder.decode(uid, "utf-8");
                break;
            }
            newUrl = newUrl + "?" + arr[1];
            return newUrl;
        }
        catch (UnsupportedEncodingException e) {
            log.error("[AssembleTool-getFengJinGetUrl] URL parsing error, url: " + url, (Throwable)e);
            throw new IllegalStateException("URL parsing error when using utf-8");
        }
    }
}

