/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.MD5;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.stereotype.Service;

@Service
public class MobikeApi {
    public static final String MOBIKE_CLIENT_ID = "duiba";
    public static final String MOBILE_SECRET = "4b6bafac8a839294a1329cd5bf90b83b";
    public static final String TEST_MOBILE_SECRET = "dbsecret";
    public static final long MOBIKE_TEST_ID = 35830L;

    public static HttpRequestBase getMobikeNotifyUrl(String url, NotifyQueueDO record, String time) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("success", String.valueOf(record.getResult()));
        if (StringUtils.isNotEmpty((String)record.getError4developer())) {
            params.put("errorMessage", record.getError4developer());
        }
        params.put("orderNum", record.getDuibaOrderNum());
        if (StringUtils.isNotEmpty((String)record.getDeveloperBizId())) {
            params.put("bizId", record.getDeveloperBizId());
        }
        params.put("accesstoken", record.getTransfer());
        params.put("client_id", MOBIKE_CLIENT_ID);
        params.put("time", time);
        params.put("sign", MobikeApi.getMobileSign(params, MobikeApi.getSecret(record.getAppId())));
        HttpPost request = new HttpPost(AssembleTool.assembleUrl(url, params));
        request.setHeader("time", time);
        request.setHeader("accesstoken", record.getTransfer());
        return request;
    }

    public static String getSecret(Long appId) {
        if (Objects.equals(appId, 35830L)) {
            return TEST_MOBILE_SECRET;
        }
        return MOBILE_SECRET;
    }

    private static boolean isTestAPP(Long appId) {
        return Objects.equals(appId, 35830L);
    }

    public static SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("accesstoken", crediMap.get("transfer"));
        params.put("client_id", MOBIKE_CLIENT_ID);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("uid", crediMap.get("uid"));
        params.put("credits", request.getParams().get("credits"));
        params.put("params", crediMap.get("params"));
        params.put("description", crediMap.get("description"));
        params.put("developBizId", crediMap.get("developBizId"));
        params.put("orderNum", crediMap.get("orderNum"));
        String account = crediMap.get("account");
        if (StringUtils.isNotEmpty((String)account)) {
            params.put("account", account);
        }
        if (MobikeApi.isTestAPP(Long.valueOf(request.getAppId()))) {
            params.put("duibatest", "true");
        }
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        params.put("time", time);
        params.put("sign", MobikeApi.getMobileSign(params, MobikeApi.getSecret(Long.valueOf(request.getAppId()))));
        String requestUrl = AssembleTool.assembleUrl(host, params);
        request.setHttpUrl(requestUrl);
        request.getParams().put("time", time);
        request.getParams().put("accesstoken", crediMap.get("transfer"));
        return request;
    }

    public CreditsMessage buildSubCreditsRequest(CreditsMessage creditsMessage) {
        String description;
        String itemCode;
        String url = creditsMessage.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("accesstoken", crediMap.get("transfer"));
        params.put("client_id", MOBIKE_CLIENT_ID);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("uid", crediMap.get("uid"));
        params.put("credits", crediMap.get("credits"));
        if (creditsMessage.getParams().get("cash") != null) {
            params.put("cash", (String)creditsMessage.getParams().get("cash"));
        }
        if (StringUtils.isNotEmpty((String)(itemCode = crediMap.get("itemCode")))) {
            params.put("itemCode", itemCode);
        }
        if (StringUtils.isNotEmpty((String)(description = crediMap.get("description")))) {
            params.put("description", description);
        }
        params.put("orderNum", crediMap.get("orderNum"));
        params.put("type", crediMap.get("type"));
        params.put("facePrice", crediMap.get("facePrice"));
        params.put("actualPrice", crediMap.get("actualPrice"));
        String ip = crediMap.get("ip");
        if (StringUtils.isNotEmpty((String)ip)) {
            params.put("ip", ip);
        }
        params.put("waitAudit", crediMap.get("waitAudit"));
        String detailParams = crediMap.get("params");
        if (StringUtils.isNotEmpty((String)detailParams)) {
            params.put("params", detailParams);
        }
        params.put("appItemId", (String)creditsMessage.getParams().get("appItemId"));
        if (!"mall".equals(creditsMessage.getRelationType()) && StringUtils.isBlank((String)((String)creditsMessage.getParams().get("appItemId")))) {
            params.put("appItemId", "0");
        }
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        params.put("time", time);
        creditsMessage.getParams().put("time", time);
        creditsMessage.getParams().put("accesstoken", crediMap.get("transfer"));
        params.put("sign", MobikeApi.getMobileSign(params, MobikeApi.getSecret(Long.valueOf(creditsMessage.getAppId()))));
        String requestUrl = AssembleTool.assembleUrl(host, params);
        creditsMessage.setHttpUrl(requestUrl);
        creditsMessage.setHttpType("post");
        creditsMessage.setAuthParams(new HashMap());
        return creditsMessage;
    }

    public SubCreditsMsgWrapper buildSubCreditsRequest(SubCreditsMsgWrapper creditsMessage) {
        String description;
        String itemCode;
        String url = creditsMessage.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("accesstoken", crediMap.get("transfer"));
        params.put("client_id", MOBIKE_CLIENT_ID);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("uid", crediMap.get("uid"));
        params.put("credits", crediMap.get("credits"));
        if (creditsMessage.getSubCreditsMsg().getParams() != null && creditsMessage.getSubCreditsMsg().getParams().get("cash") != null) {
            params.put("cash", (String)creditsMessage.getSubCreditsMsg().getParams().get("cash"));
        }
        if (StringUtils.isNotEmpty((String)(itemCode = crediMap.get("itemCode")))) {
            params.put("itemCode", itemCode);
        }
        if (StringUtils.isNotEmpty((String)(description = crediMap.get("description")))) {
            params.put("description", description);
        }
        params.put("orderNum", crediMap.get("orderNum"));
        params.put("type", crediMap.get("type"));
        params.put("facePrice", crediMap.get("facePrice"));
        params.put("actualPrice", crediMap.get("actualPrice"));
        String ip = crediMap.get("ip");
        if (StringUtils.isNotEmpty((String)ip)) {
            params.put("ip", ip);
        }
        params.put("waitAudit", crediMap.get("waitAudit"));
        String detailParams = crediMap.get("params");
        if (StringUtils.isNotEmpty((String)detailParams)) {
            params.put("params", detailParams);
        }
        if (creditsMessage.getSubCreditsMsg().getParams() != null) {
            params.put("appItemId", (String)creditsMessage.getSubCreditsMsg().getParams().get("appItemId"));
        }
        if (!"mall".equals(creditsMessage.getSubCreditsMsg().getRelationType()) && StringUtils.isBlank((String)((String)creditsMessage.getSubCreditsMsg().getParams().get("appItemId")))) {
            params.put("appItemId", "0");
        }
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        params.put("time", time);
        if (creditsMessage.getSubCreditsMsg().getParams() == null) {
            creditsMessage.getSubCreditsMsg().setParams(new HashMap());
        }
        creditsMessage.getSubCreditsMsg().getParams().put("time", time);
        creditsMessage.getSubCreditsMsg().getParams().put("accesstoken", crediMap.get("transfer"));
        params.put("sign", MobikeApi.getMobileSign(params, MobikeApi.getSecret(creditsMessage.getSubCreditsMsg().getAppId())));
        String requestUrl = AssembleTool.assembleUrl(host, params);
        creditsMessage.setHttpUrl(requestUrl);
        creditsMessage.getSubCreditsMsg().setHttpType(2);
        creditsMessage.getSubCreditsMsg().setAuthParams(new HashMap());
        return creditsMessage;
    }

    private static String getMobileSign(TreeMap<String, String> params, String secret) {
        Set<String> keys = params.keySet();
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(key);
            builder.append("=");
            builder.append(params.get(key));
        }
        builder.append("@");
        builder.append(secret);
        try {
            return MD5.md5(builder.toString());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

