/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.api.tools.InnerLogger;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.thirdparty.enums.CallbackChannelTypeEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubCreditsToDeveloper {
    private static final Logger logger = LoggerFactory.getLogger(SubCreditsToDeveloper.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private CustomService customService;
    @Autowired
    private DefaultMQProducer rocketMqProducer;
    @Autowired
    private ConsumerCreditsLogService consumerCreditsLogService;
    @Resource(name="httpCallbackExecutorService")
    private ExecutorService httpCallbackExecutorService;

    public void submit(CreditsMessage req, String msgTopic, String msgTag, String msgKey) {
        HttpGet http;
        CreditsMessage request = this.customService.getRequestCredits(req);
        if ("post".equals(request.getHttpType())) {
            Map authParams = request.getAuthParams();
            if (MapUtils.isNotEmpty((Map)authParams)) {
                authParams.remove("appSecret");
            }
            http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
            HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [post url " + request.getHttpUrl() + "][authParams " + request.getAuthParams() + "][consumerId " + request.getConsumerId() + "]");
        } else {
            http = new HttpGet(request.getHttpUrl());
            HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [get url " + request.getHttpUrl() + "][consumerId " + request.getConsumerId() + "]");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("consumerId", (Object)request.getConsumerId());
        jsonObject.put("appId", (Object)request.getAppId());
        jsonObject.put("credits", (Object)this.getValue(request.getParams(), "credits"));
        jsonObject.put("relationId", (Object)request.getRelationId());
        jsonObject.put("relationType", (Object)request.getRelationType());
        jsonObject.put("httpType", (Object)request.getHttpType());
        InnerLogger.log((int)2, (int)62, (String)"", (String)"", (JSONObject)jsonObject);
        this.setHttpHeader(request, (HttpRequestBase)http);
        this.httpAsyncClient(request, (HttpRequestBase)http, msgTopic, msgTag, msgKey);
    }

    private String getValue(Map<String, String> params, String key) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        return params.get(key);
    }

    private void httpAsyncClient(final CreditsMessage request, HttpRequestBase http, final String msgTopic, final String msgTag, final String msgKey) {
        this.httpAsyncClientPool.submit(request.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("completed");
                    Header header = response.getEntity().getContentEncoding();
                    String result = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
                    String body = SubCreditsToDeveloper.this.customService.getResponseCredits(NumberUtils.parseLong((String)request.getAppId(), (long)0L), result);
                    resp.setMessage(HttpRequestLog.subBody(body));
                }
                catch (Exception e) {
                    logger.error("toDeveloper completed", (Throwable)e);
                }
                finally {
                    SubCreditsToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                logger.error("toDeveloper failed bizId:" + request.getRelationId() + " bizType:" + request.getRelationType(), (Throwable)ex);
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    logger.error("toDeveloper failed", (Throwable)e);
                }
                finally {
                    SubCreditsToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
                }
            }

            public void cancelled() {
                logger.info("toDeveloper cancelled bizId:" + request.getRelationId() + " bizType:" + request.getRelationType());
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage("http cancelled");
                }
                catch (Exception e) {
                    logger.error("toDeveloper cancelled", (Throwable)e);
                }
                finally {
                    SubCreditsToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
                }
            }
        });
    }

    private void setHttpHeader(CreditsMessage request, HttpRequestBase http) {
        String time;
        if (this.customService.isMobike(Long.valueOf(request.getAppId())) && StringUtils.isNotEmpty((String)(time = (String)request.getParams().get("time")))) {
            http.setHeader((Header)new BasicHeader("time", time));
            http.setHeader((Header)new BasicHeader("accesstoken", (String)request.getParams().get("accesstoken")));
        }
        if (this.customService.isCainiao(Long.valueOf(request.getAppId()))) {
            http.setHeader("Accept", "text/xml,text/javascript");
            http.setHeader("User-Agent", "top-sdk-java");
            http.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            http.setHeader("Accept-Encoding", "gzip");
        }
        if (this.customService.isHaiDiLao(Long.valueOf(request.getAppId()))) {
            this.customService.setHaidilaoSubAndAddHttpHeader(request, http);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finallyBlock(CreditsMessage req, CreditsCallbackMessage resp, String msgTopic, String msgTag, String msgKey, String code) {
        try {
            resp.setRelationId(req.getRelationId());
            resp.setRelationType(req.getRelationType());
            resp.setParams(req.getParams());
            resp.setAppId(req.getAppId());
            resp.setConsumerId(req.getConsumerId());
            resp.setHttpUrl(req.getHttpUrl());
            String body = JsonTool.objectToJson(resp);
            if (req.getParams() != null && CallbackChannelTypeEnum.ROCKETMQ.getType().equals(req.getParams().get("callbackMessageType"))) {
                this.sendRocketMQMessage(msgTopic, msgTag, msgKey, body);
            } else {
                this.messageService.sendMsg(msgTopic, msgTag, msgKey, body);
            }
            this.saveCreditsLog(req, resp);
        }
        catch (Exception e) {
            logger.error("credits callback: bizId:" + req.getRelationId() + " bizType:" + req.getRelationType(), (Throwable)e);
        }
        finally {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [code " + code + "] [bizId " + req.getRelationId() + "] [type " + req.getRelationType() + "] [callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
        }
    }

    private void sendRocketMQMessage(String topic, String tag, String key, String message) {
        Message msg = new Message(topic, tag, key, message.getBytes(Charset.forName("utf-8")));
        try {
            this.rocketMqProducer.send(msg);
        }
        catch (Exception e) {
            logger.error("subCredits sendRocketMQMessage", (Object)e.getMessage());
        }
    }

    private void saveCreditsLog(CreditsMessage request, CreditsCallbackMessage response) {
        this.httpCallbackExecutorService.execute(() -> {
            try {
                JSONObject json;
                if (response == null || StringUtils.isBlank((String)response.getMessage())) {
                    return;
                }
                if ("completed".equals(response.getCallbackType()) && (json = JSON.parseObject((String)response.getMessage())) != null && ("success".equalsIgnoreCase(json.getString("status")) || "ok".equalsIgnoreCase(json.getString("status")))) {
                    this.consumerCreditsLogService.save((CreditsRequest)request, (CreditsResponse)response);
                }
            }
            catch (Exception e) {
                logger.error("\u79ef\u5206\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25, bizId={}, bizType={}", new Object[]{request.getRelationId(), request.getRelationType(), e});
            }
        });
    }
}

