/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.tools.InnerLogger;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.thirdparty.dto.VirtualCurrencyCallbackMessage;
import cn.com.duiba.thirdparty.dto.VirtualCurrencyMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubVirtualCurrencyToDeveloper {
    private static final Logger logger = LoggerFactory.getLogger(SubVirtualCurrencyToDeveloper.class);
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private DefaultMQProducer rocketMqProducer;
    @Autowired
    private MessageService messageService;

    public void submit(VirtualCurrencyMessage request, String msgTopic, String msgTag, String msgKey) {
        HttpGet http;
        if ("post".equals(request.getHttpType())) {
            Map authParams = request.getAuthParams();
            if (MapUtils.isNotEmpty((Map)authParams)) {
                authParams.remove("appSecret");
            }
            http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
            HttpRequestLog.logUrl("[action subVirtualCurrency] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [post url " + request.getHttpUrl() + "][authParams " + request.getAuthParams() + "][consumerId " + request.getConsumerId() + "]");
        } else {
            http = new HttpGet(request.getHttpUrl());
            HttpRequestLog.logUrl("[action subVirtualCurrency] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [get url " + request.getHttpUrl() + "][consumerId " + request.getConsumerId() + "]");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("consumerId", (Object)request.getConsumerId());
        jsonObject.put("appId", (Object)request.getAppId());
        jsonObject.put("currencies", (Object)this.getValue(request.getParams(), "currencies"));
        jsonObject.put("relationId", (Object)request.getRelationId());
        jsonObject.put("relationType", (Object)request.getRelationType());
        jsonObject.put("httpType", (Object)request.getHttpType());
        InnerLogger.log((int)2, (int)62, (String)"", (String)"", (JSONObject)jsonObject);
        this.httpAsyncClient(request, (HttpRequestBase)http, msgTopic, msgTag, msgKey);
    }

    private String getValue(Map<String, String> params, String key) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        return params.get(key);
    }

    private void httpAsyncClient(final VirtualCurrencyMessage request, HttpRequestBase http, final String msgTopic, final String msgTag, final String msgKey) {
        this.httpAsyncClientPool.submit(request.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                VirtualCurrencyCallbackMessage resp = new VirtualCurrencyCallbackMessage();
                try {
                    resp.setCallbackType("completed");
                    Header header = response.getEntity().getContentEncoding();
                    String result = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
                    resp.setMessage(HttpRequestLog.subBody(result));
                }
                catch (Exception e) {
                    logger.error("toDeveloper completed", (Throwable)e);
                }
                finally {
                    SubVirtualCurrencyToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                logger.error("toDeveloper failed bizId:" + request.getRelationId() + " bizType:" + request.getRelationType(), (Throwable)ex);
                VirtualCurrencyCallbackMessage resp = new VirtualCurrencyCallbackMessage();
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    logger.error("toDeveloper failed", (Throwable)e);
                }
                finally {
                    SubVirtualCurrencyToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
                }
            }

            public void cancelled() {
                logger.info("toDeveloper cancelled bizId:" + request.getRelationId() + " bizType:" + request.getRelationType());
                VirtualCurrencyCallbackMessage resp = new VirtualCurrencyCallbackMessage();
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage("http cancelled");
                }
                catch (Exception e) {
                    logger.error("toDeveloper cancelled", (Throwable)e);
                }
                finally {
                    SubVirtualCurrencyToDeveloper.this.finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finallyBlock(VirtualCurrencyMessage req, VirtualCurrencyCallbackMessage resp, String msgTopic, String msgTag, String msgKey, String code) {
        try {
            resp.setRecordId(req.getRecordId());
            resp.setAccountId(req.getAccountId());
            resp.setRelationId(req.getRelationId());
            resp.setRelationType(req.getRelationType());
            resp.setParams(req.getParams());
            resp.setAppId(req.getAppId());
            resp.setConsumerId(req.getConsumerId());
            resp.setHttpUrl(req.getHttpUrl());
            String body = JsonTool.objectToJson(resp);
            this.sendRocketMQMessage(msgTopic, msgTag, msgKey, body);
        }
        catch (Exception e) {
            logger.error("virtualCurrency callback: bizId:" + req.getRelationId() + " bizType:" + req.getRelationType(), (Throwable)e);
        }
        finally {
            HttpRequestLog.logUrl("[action subVirtualCurrency] [tag response] [code " + code + "] [bizId " + req.getRelationId() + "] [type " + req.getRelationType() + "] [callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
        }
    }

    private void sendRocketMQMessage(String topic, String tag, String key, String message) {
        Message msg = new Message(topic, tag, key, message.getBytes(Charset.forName("utf-8")));
        try {
            this.rocketMqProducer.send(msg);
        }
        catch (Exception e) {
            logger.error("subVirtualCurrency sendRocketMQMessage", (Object)e.getMessage());
        }
    }
}

