/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.WatsonsConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.WatsonsSignUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WatsonsApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatsonsApi.class);
    private static final String DELIMITER = "?";
    @Autowired
    private WatsonsConfig watsonsConfig;

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        List<String> analysisList = WatsonsApi.analysisUrl(url);
        if (analysisList.isEmpty()) {
            return request;
        }
        String host = analysisList.get(0);
        Map<String, String> urlParams = AssembleTool.getUrlParams(analysisList.get(1));
        JSONObject data = new JSONObject();
        data.put("uid", (Object)urlParams.get("uid"));
        data.put("keycode", (Object)urlParams.get("params"));
        TreeMap<String, String> paramMap = this.getBaseParam();
        paramMap.put("data", data.toJSONString());
        String sign = WatsonsSignUtil.getSign(paramMap, this.watsonsConfig.getToken());
        paramMap.put("sign", sign);
        paramMap.put("token", this.watsonsConfig.getToken());
        request.setHttpUrl(AssembleTool.assembleUrl(host, paramMap));
        return request;
    }

    public String getVirtualRespone(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            LOGGER.info("[WatsonsApi-getVirtualRespone]\u5c48\u81e3\u6c0f-\u865a\u62df\u5546\u54c1\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
            return this.resultFail("\u5c48\u81e3\u6c0f\u865a\u62df\u5546\u54c1\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
        }
        try {
            JSONObject originJson = JSON.parseObject((String)body);
            Boolean isSuccess = originJson.getBoolean("is_success");
            if (isSuccess.booleanValue()) {
                return this.resultSuccessWithData(originJson.getString("data"));
            }
            return this.resultFail(originJson.getString("message"));
        }
        catch (Exception e) {
            LOGGER.warn("[WatsonsApi-getVirtualRespone]\u5c48\u81e3\u6c0f-\u54cd\u5e94JSON\u89e3\u6790\u9519\u8bef:", (Throwable)e);
            return this.resultFail("\u5c48\u81e3\u6c0f\u54cd\u5e94JSON\u89e3\u6790\u9519\u8bef");
        }
    }

    private static List<String> analysisUrl(String url) {
        ArrayList analysisList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                analysisList.add(url.substring(0, index));
                analysisList.add(url.substring(index + 1));
            } else {
                analysisList.add(url);
                analysisList.add("");
            }
        }
        return analysisList;
    }

    private TreeMap<String, String> getBaseParam() {
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appId", this.watsonsConfig.getDuibaIdentifier());
        paramMap.put("certiId", this.watsonsConfig.getCertiId());
        paramMap.put("date", DateUtils.getSecondStr((Date)new Date()));
        return paramMap;
    }

    private String resultFail(String message) {
        JSONObject result = new JSONObject();
        result.put("status", (Object)"fail");
        result.put("errorMessage", (Object)message);
        return result.toJSONString();
    }

    private String resultSuccessWithData(String data) {
        JSONObject result = new JSONObject();
        result.put("status", (Object)"success");
        result.put("data", (Object)data);
        return result.toJSONString();
    }
}

