/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.ErrorCode;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class YoukuApi {
    private static Logger logger = LoggerFactory.getLogger(YoukuApi.class);
    public static final String YOUKU_APPKEY = "kgc9ebdZeg5PpXq9";
    public static final String YOUKU_APPSECRET = "kjnmcdmdephhealfkakijdnojekfhihg";
    public static final String YOUKU_ACTION_POINT = "youku.duiba.mall.consume.point";
    public static final String YOUKU_ACTION_NOTICE = "youku.duiba.mall.exchange.result.notice";
    public static final String YOUKU_ACTION_VIRTUAL = "youku.duiba.mall.send.right";
    public static final String YOUKU_VERSION = "3.0";
    public static final String YOUKU_SIGN_METHOD = "md5";
    private static final String DELIMITER = "?";

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = YoukuApi.getGateway(url);
        Map params = request.getAuthParams();
        TreeMap authParams = new TreeMap();
        authParams.put("type", params.get("type"));
        authParams.put("uid", params.get("uid"));
        authParams.put("credits", params.get("credits"));
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("type", params.get("type"));
        authParams.put("description", params.get("description"));
        authParams.put("actualPrice", params.get("actualPrice"));
        authParams.put("ip", params.get("ip"));
        authParams.put("time", String.valueOf(new Date().getTime() / 1000L));
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("itemCode")))) {
            authParams.put("itemCode", params.get("itemCode"));
        }
        authParams = YoukuApi.getSign(authParams, YOUKU_ACTION_POINT);
        request.setHttpType("get");
        request.setHttpUrl(AssembleTool.assembleUrl(host, authParams));
        return request;
    }

    public HttpRequestBase getRequestNotify(String url, NotifyQueueDO record) {
        TreeMap authParams = new TreeMap();
        authParams.put("success", String.valueOf(record.getResult()));
        authParams.put("uid", record.getPartnerUserId());
        authParams.put("orderNum", record.getDuibaOrderNum());
        if (!record.getResult().booleanValue()) {
            authParams.put("errorMessage", StringUtils.isBlank((CharSequence)record.getError4developer()) ? "\u672a\u77e5\u539f\u56e0" : record.getError4developer());
        }
        authParams = YoukuApi.getSign(authParams, YOUKU_ACTION_NOTICE);
        return new HttpPost(AssembleTool.assembleUrl(url, authParams));
    }

    public String parseCreditsRsp(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            logger.info("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        duibaDoc.put("errorMessage", json.getString("errorMessage"));
        duibaDoc.put("status", json.getString("status"));
        duibaDoc.put("bizId", json.getString("traceId"));
        duibaDoc.put("credits", json.getString("credits"));
        return JsonTool.objectToJson(duibaDoc);
    }

    public static TreeMap getSign(TreeMap params, String action) {
        String sign;
        params.put("action", action);
        params.put("client_id", YOUKU_APPKEY);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", YOUKU_VERSION);
        params.put("sign_method", YOUKU_SIGN_METHOD);
        StringBuffer signString = new StringBuffer();
        try {
            for (Map.Entry entry : params.entrySet()) {
                signString.append((String)entry.getKey());
                signString.append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
        }
        catch (Exception e) {
            logger.error("YoukuApi getSign error:", (Object)("\u7b7e\u540d\u5b57\u7b26\u4e32\u62fc\u63a5\u9519\u8bef\uff1a" + e.getMessage() + "\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01"));
        }
        signString.append(YOUKU_APPSECRET);
        try {
            sign = YoukuApi.md5Sign(signString.toString());
        }
        catch (Exception e) {
            params.put("error", ErrorCode.E9999999.getErrorCode());
            return params;
        }
        return YoukuApi.packageRequestParams(params, sign);
    }

    private static TreeMap packageRequestParams(TreeMap params, String sign) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("\"client_id\":");
        buffer.append("\"");
        buffer.append(params.get("client_id"));
        buffer.append("\",");
        buffer.append("\"timestamp\":");
        buffer.append("\"");
        buffer.append(params.get("timestamp"));
        buffer.append("\",");
        buffer.append("\"version\":");
        buffer.append("\"");
        buffer.append(params.get("version"));
        buffer.append("\",");
        buffer.append("\"sign_method\":");
        buffer.append("\"");
        buffer.append(params.get("sign_method"));
        buffer.append("\",");
        buffer.append("\"sign\":");
        buffer.append("\"");
        buffer.append(sign);
        buffer.append("\",");
        buffer.append("\"action\":");
        buffer.append("\"");
        buffer.append(params.get("action"));
        buffer.append("\"");
        buffer.append("}");
        params.put("opensysparams", buffer.toString());
        params.remove("client_id");
        params.remove("timestamp");
        params.remove("version");
        params.remove("sign_method");
        params.remove("action");
        return params;
    }

    private static String md5Sign(String signString) {
        return DigestUtils.md5Hex((String)signString);
    }

    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper request) {
        String url = request.getHttpUrl();
        String host = YoukuApi.getGateway(url);
        Map params = request.getSubCreditsMsg().getAuthParams();
        TreeMap authParams = new TreeMap();
        authParams.put("type", params.get("type"));
        authParams.put("uid", params.get("uid"));
        authParams.put("credits", params.get("credits"));
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("type", params.get("type"));
        authParams.put("description", params.get("description"));
        authParams.put("actualPrice", params.get("actualPrice"));
        authParams.put("ip", params.get("ip"));
        authParams.put("time", String.valueOf(System.currentTimeMillis() / 1000L));
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("itemCode")))) {
            authParams.put("itemCode", params.get("itemCode"));
        }
        authParams = YoukuApi.getSign(authParams, YOUKU_ACTION_POINT);
        request.getSubCreditsMsg().setHttpType(1);
        request.setHttpUrl(AssembleTool.assembleUrl(host, authParams));
        return request;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        List<String> analysisList = YoukuApi.analysisUrl(url);
        if (analysisList.isEmpty()) {
            return request;
        }
        String host = analysisList.get(0);
        Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));
        TreeMap authParams = new TreeMap();
        authParams.put("uid", params.get("uid"));
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("ip", params.get("ip"));
        authParams.put("rightEname", params.get("params"));
        authParams = YoukuApi.getSign(authParams, YOUKU_ACTION_VIRTUAL);
        request.setHttpUrl(AssembleTool.assembleUrl(host, authParams));
        return request;
    }

    public String getVirtualRespone(String body) {
        JSONObject jsonBody;
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            logger.warn("[YoukuApi-getVirtualRespone]\u4f18\u9177\u54cd\u5e94JSON\u89e3\u6790\u9519\u8bef:" + e.getMessage() + ",\u4f18\u9177\u63a5\u53e3\u539f\u54cd\u5e94\u4e3a\uff1a" + body);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u4f18\u9177\u54cd\u5e94JSON\u89e3\u6790\u9519\u8bef");
            return JsonTool.objectToJson(duibaDoc);
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        String errno = json.getString("errno");
        if (StringUtils.isBlank((CharSequence)errno)) {
            logger.info("[YoukuApi-getVirtualRespone]\u4f18\u9177\u54cd\u5e94\u72b6\u6001\u7801\u4e3a\u7a7a,\u4f18\u9177\u63a5\u53e3\u539f\u54cd\u5e94\u4e3a\uff1a" + body);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u4f18\u9177\u63a5\u53e3\u72b6\u6001\u7801\u4e3a\u7a7a");
            return JsonTool.objectToJson(duibaDoc);
        }
        if (errno.equals("0")) {
            duibaDoc.put("status", "success");
            duibaDoc.put("supplierBizId", json.getString("traceId"));
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("supplierBizId", json.getString("traceId"));
            duibaDoc.put("errorMessage", json.getString("errmsg"));
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    @Nullable
    private static String getGateway(String url) {
        int index;
        if (StringUtils.isNotBlank((CharSequence)url) && (index = url.indexOf(DELIMITER)) != -1) {
            return url.substring(0, index);
        }
        return url;
    }

    private static List<String> analysisUrl(String url) {
        ArrayList analysisList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                analysisList.add(url.substring(0, index));
                analysisList.add(url.substring(index + 1, url.length()));
            } else {
                analysisList.add(url);
                analysisList.add("");
            }
        }
        return analysisList;
    }
}

