/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.virtualcard;

import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.thirdparty.dto.VirtualCardCallbackMessage;
import cn.com.duiba.thirdparty.dto.VirtualCardMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualCard4Devloper {
    private static Logger logger = LoggerFactory.getLogger(VirtualCard4Devloper.class);
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;

    public void submit(final VirtualCardMessage request, final String msgTopic, final String msgTag, final String msgKey) {
        HttpPost http;
        if ("post".equals(request.getHttpType())) {
            http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
            HttpRequestLog.logUrl("[action subVirtualCard] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [http_method post] [url " + request.getHttpUrl() + "] [authParams " + request.getAuthParams() + "]");
        } else {
            http = new HttpGet(AssembleTool.assembleUrl(request.getHttpUrl(), request.getAuthParams()));
            HttpRequestLog.logUrl("[action subVirtualCard] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [http_method get] [url " + request.getHttpUrl() + "]");
        }
        this.httpAsyncClientPool.submit(request.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                VirtualCardCallbackMessage resp = new VirtualCardCallbackMessage(request);
                try {
                    resp.setCallbackType("completed");
                    resp.setMessage(EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                catch (Exception e) {
                    logger.error("toDeveloper completed", (Throwable)e);
                }
                finally {
                    VirtualCard4Devloper.this.finallyBlock(resp, msgTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                logger.error("toDeveloper failed bizId:{},bizType={}", new Object[]{request.getRelationId(), request.getRelationType(), ex});
                VirtualCardCallbackMessage resp = new VirtualCardCallbackMessage(request);
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    logger.error("toDeveloper failed", (Throwable)e);
                }
                finally {
                    VirtualCard4Devloper.this.finallyBlock(resp, msgTopic, msgTag, msgKey, "");
                }
            }

            public void cancelled() {
                VirtualCardCallbackMessage resp = new VirtualCardCallbackMessage(request);
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage("http cancelled");
                }
                catch (Exception e) {
                    logger.error("toDeveloper cancelled", (Throwable)e);
                }
                finally {
                    VirtualCard4Devloper.this.finallyBlock(resp, msgTopic, msgTag, msgKey, "");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finallyBlock(VirtualCardCallbackMessage resp, String msgTopic, String msgTag, String msgKey, String code) {
        try {
            String body = JsonTool.objectToJson(resp);
            if (msgTopic.contains("MQ")) {
                this.rocketMQMsgProducer.sendMsg(msgTopic, msgTag, msgKey, body, false, null);
            } else {
                this.messageService.sendMsg(msgTopic, msgTag, msgKey, body);
            }
        }
        catch (Exception e) {
            logger.error("toDeveloper failed bizId:{},bizType={}", new Object[]{resp.getRelationId(), resp.getRelationType(), e});
        }
        finally {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [code " + code + "] [bizId " + resp.getRelationId() + "] [type " + resp.getRelationType() + "] [callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
        }
    }
}

