/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mq;

import cn.com.duiba.api.bo.addcredits.AddCreditsMsgDto;
import cn.com.duiba.api.bo.mq.EmailMsg;
import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.api.bo.virtual.VirtualMsgDto;
import cn.com.duiba.api.tools.GZIPCompressUtil;
import cn.com.duiba.crecord.message.CrecordAsyncHttp;
import cn.com.duiba.mq.RocketMQTopicConstant;
import cn.com.duiba.mq.dinghandler.SendDingMsgHelper;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.service.CreditsService;
import cn.com.duiba.service.DevAppTrustConfService;
import cn.com.duiba.service.EmailService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.thirdparty.mq.msg.NotifyDeveloperMsg;
import cn.com.duiba.thirdparty.mq.msg.ValidatePrizeTagMsg;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="bootRocketMqMessageListener")
public class RocketMqMessageListener
implements MessageListenerConcurrently {
    private static Logger logger = LoggerFactory.getLogger(RocketMqMessageListener.class);
    @Autowired
    private DevAppTrustConfService devAppTrustConfService;
    @Autowired
    private RocketMQTopicConstant rocketMQTopicConstant;
    @Autowired
    private CrecordAsyncHttp crecordAsyncHttp;
    @Autowired
    private CreditsService creditsService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private SendDingMsgHelper sendDingMsgHelper;

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        try {
            for (MessageExt message : msgs) {
                String topic;
                if (this.consumePerMessage(message, topic = message.getTopic())) continue;
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ConsumeConcurrentlyStatus.RECONSUME_LATER;
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    private boolean consumePerMessage(MessageExt message, String topic) {
        boolean isConsumed = true;
        if (Objects.equals(this.rocketMQTopicConstant.getCrecordRequest(), topic)) {
            String body = new String(message.getBody(), Charset.forName("utf-8"));
            this.crecordAsyncHttp.asyncSubmit(body);
        } else if (Objects.equals(this.rocketMQTopicConstant.getSubCredits(), topic)) {
            this.creditsService.subCredits(SubCreditsMsgDto.decode((byte[])message.getBody()));
        } else if (Objects.equals(this.rocketMQTopicConstant.getNotifyDeveloper(), topic)) {
            this.creditsService.notifyDeveloper(NotifyDeveloperMsg.decode((byte[])message.getBody()));
        } else if (Objects.equals(this.rocketMQTopicConstant.getAddCredits(), topic)) {
            this.creditsService.addCredits(AddCreditsMsgDto.decode((byte[])message.getBody()));
        } else if (Objects.equals(this.rocketMQTopicConstant.getVirtualExchange(), topic)) {
            this.creditsService.virtualExchange(VirtualMsgDto.decode((byte[])message.getBody()));
        } else if (Objects.equals(this.rocketMQTopicConstant.getValidatePrizeTag(), topic)) {
            this.devAppTrustConfService.sendDevPrizeTagMsg(ValidatePrizeTagMsg.decode((byte[])message.getBody()));
        } else if (Objects.equals(this.rocketMQTopicConstant.getSendEmail(), topic)) {
            this.emailService.sendEmail(EmailMsg.decode((byte[])message.getBody()));
        } else if (Objects.equals(this.rocketMQTopicConstant.getNotifyQueue(), topic)) {
            this.doNotify(message);
        } else if (Objects.equals(this.rocketMQTopicConstant.getDingMessage(), topic)) {
            this.sendDingMsgHelper.handleMqMessage(message);
        } else {
            logger.warn("\u6682\u4e0d\u5e94\u8be5\u6709\u5176\u4ed6topic\u88ab\u6d88\u8d39, topic:{}, message:{}", (Object)topic, (Object)message);
            isConsumed = false;
        }
        return isConsumed;
    }

    private void doNotify(MessageExt message) {
        String body = GZIPCompressUtil.ungzip((byte[])message.getBody());
        if (StringUtils.isNotBlank((String)body)) {
            NotifyQueueDto dto = (NotifyQueueDto)JSONObject.parseObject((String)body, NotifyQueueDto.class);
            this.notifyService.notifyFromMq(dto);
        }
    }
}

