/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mq.dinghandler;

import cn.com.duiba.mq.dinghandler.SendDingMsgTagIHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SendDingMsgHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SendDingMsgHelper.class);
    private static Map<String, SendDingMsgTagIHandler> tagAndTagHandlers = new HashMap<String, SendDingMsgTagIHandler>();

    public static void registerTagHandler(SendDingMsgTagIHandler handler) {
        if (handler == null) {
            LOG.warn("registerTagHandler SendDingMsgTagIHandler is null");
            return;
        }
        tagAndTagHandlers.put(handler.getTag(), handler);
    }

    public boolean handleMqMessage(MessageExt message) {
        String tag = message.getTags();
        String topic = message.getTopic();
        if (StringUtils.isEmpty((CharSequence)tag)) {
            LOG.warn("SendDingMsg handleMqMessage tag is null,topic={}", (Object)topic);
            return false;
        }
        SendDingMsgTagIHandler tagHandler = tagAndTagHandlers.get(tag);
        if (tagHandler == null) {
            LOG.warn("SendDingMsg handleMqMessage topic={},tag={}\u65e0\u5bf9\u5e94\u7684tag\u6d88\u606f\u5904\u7406\u5668", (Object)topic, (Object)tag);
            return false;
        }
        byte[] mqMsg = message.getBody();
        if (mqMsg == null) {
            LOG.warn("SendDingMsg handleMqMessage topic={},tag={},Mq\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a", (Object)topic, (Object)tag);
            return false;
        }
        return tagHandler.handleMQMessage(mqMsg);
    }
}

