/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.notifycenter.remoteimpl;

import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.thirdparty.api.RemoteNotifyDeveloperService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteNotifyQueueServiceImpl
implements RemoteNotifyDeveloperService {
    private static Logger log = LoggerFactory.getLogger(RemoteNotifyQueueServiceImpl.class);
    @Autowired
    private NotifyQueueDAO notifyQueueDAO;
    @Autowired
    private NotifyService notifyService;

    public void notifyDeveloper(NotifyQueueDto notifyQueue) {
        try {
            NotifyQueueDO queue = (NotifyQueueDO)BeanUtils.copy((Object)notifyQueue, NotifyQueueDO.class);
            DBTimeProfile.enter((String)"insert");
            if (queue.getTimes() == null) {
                queue.setTimes(0);
            }
            if (queue.getNotifyType() == null) {
                queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
            }
            if (NotifyTypeEnum.getByCode((Integer)queue.getNotifyType()) == null) {
                throw new Exception("\u901a\u77e5\u7c7b\u578b\u4e0d\u5b58\u5728;queue:" + JSON.toJSONString((Object)queue));
            }
            String errorMsg = queue.getError4developer();
            if (StringUtils.isNotBlank((String)errorMsg) && errorMsg.length() > 500) {
                queue.setError4developer(errorMsg.substring(0, 500));
            }
            this.notifyQueueDAO.insert(queue);
            DBTimeProfile.release();
            DBTimeProfile.enter((String)"notify");
            this.notifyService.notify(queue, "remote call");
            DBTimeProfile.release();
        }
        catch (Exception e) {
            log.error("notify error", (Throwable)e);
        }
    }
}

