/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.notifycenter.service.impl;

import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.BussinessTypesService;
import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="notifyService")
public class NotifyServiceImpl
extends AbstractSimpleElasticJob
implements NotifyService {
    private static Logger log = LoggerFactory.getLogger(NotifyServiceImpl.class);
    @Autowired
    private NotifyHttpClientPool notifyHttpClientPool;
    @Autowired
    private NotifyQueueDAO notifyQueueDAO;
    @Autowired
    private BussinessTypesService bussinessTypesService;
    @Autowired
    private CustomService customService;
    @Value(value="${notifycenter.timer.enable}")
    private boolean timerEnable;
    private static Map<Integer, Long> timeMap = new HashMap<Integer, Long>();

    public void process(JobExecutionMultipleShardingContext shardingContext) {
        this.scan();
    }

    @Override
    public void scan() {
        if (!this.timerEnable) {
            return;
        }
        long start = System.currentTimeMillis();
        List<NotifyQueueDO> list = this.notifyQueueDAO.findNeedNotifyList();
        int index = 0;
        for (NotifyQueueDO queue : list) {
            if (index++ % 100 == 0) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.notify(queue, "scan");
        }
        long end = System.currentTimeMillis();
        log.debug("notify scan size: {}, time: {} ms", (Object)list.size(), (Object)(end - start));
    }

    @Override
    public void notify(NotifyQueueDO queue, String fromSource) {
        try {
            FutureCallback<HttpResponse> callback = this.getFutureCallback(queue);
            HttpUriRequest request = this.bussinessTypesService.getRequest(queue);
            if (request != null) {
                NotifyTypeEnum notify = NotifyTypeEnum.getByCode((Integer)queue.getNotifyType());
                HttpRequestLog.logUrl("[action notify]] [notifyType = " + notify.getDescription() + "] [tag request] [bizId " + queue.getDuibaOrderNum() + "] [url " + String.valueOf(request.getURI()) + "] [fromSource " + fromSource + "]");
                this.notifyHttpClientPool.submit(queue.getAppId(), request, callback);
            } else {
                log.warn("notifyQueueId={}, can't gen notify url,delete. {}", (Object)queue.getId(), (Object)JSON.toJSONString((Object)queue));
                this.notifyQueueDAO.finish(queue.getId());
            }
        }
        catch (Exception e) {
            this.notifyQueueDAO.finish(queue.getId());
            log.error("notifyQueueId=" + queue.getId() + ",submit error:" + JSON.toJSONString((Object)queue), (Throwable)e);
        }
    }

    @Override
    public Date getNextTime(NotifyQueueDO notifyQueue) {
        return new Date(System.currentTimeMillis() + timeMap.get(notifyQueue.getTimes()));
    }

    private FutureCallback<HttpResponse> getFutureCallback(NotifyQueueDO queue) {
        NotifyFutureCallback callback = "reSignCard".equals(queue.getRelationType()) ? new NotifyFutureCallback(queue) : new CreditsNotifyFutureCallback(queue);
        return callback;
    }

    @Override
    public void notifyFromMq(NotifyQueueDto notifyQueue) {
        try {
            NotifyQueueDO queue = (NotifyQueueDO)BeanUtils.copy((Object)notifyQueue, NotifyQueueDO.class);
            if (queue.getTimes() == null) {
                queue.setTimes(0);
            }
            if (queue.getNotifyType() == null) {
                queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
            }
            if (NotifyTypeEnum.getByCode((Integer)queue.getNotifyType()) == null) {
                log.error("\u901a\u77e5\u7c7b\u578b\u4e0d\u5b58\u5728;queue:{}", (Object)JSON.toJSONString((Object)queue));
                return;
            }
            String errorMsg = queue.getError4developer();
            if (StringUtils.isNotBlank((String)errorMsg) && errorMsg.length() > 500) {
                queue.setError4developer(errorMsg.substring(0, 500));
            }
            this.notifyQueueDAO.insert(queue);
            this.notify(queue, "mq call");
        }
        catch (Exception e) {
            log.error("notify error", (Throwable)e);
        }
    }

    static {
        timeMap.put(0, 120000L);
        timeMap.put(1, 600000L);
        timeMap.put(2, 600000L);
        timeMap.put(3, 3600000L);
        timeMap.put(4, 0x6DDD00L);
        timeMap.put(5, 21600000L);
        timeMap.put(6, 54000000L);
    }

    class CreditsNotifyFutureCallback
    extends NotifyFutureCallback {
        public CreditsNotifyFutureCallback(NotifyQueueDO notifyQueue) {
            super(notifyQueue);
        }

        @Override
        protected String convertBody4Dcustom(String entity) {
            return NotifyServiceImpl.this.customService.getResponseNotify(this.notifyQueue.getAppId(), entity);
        }
    }

    class NotifyFutureCallback
    implements FutureCallback<HttpResponse> {
        protected NotifyQueueDO notifyQueue;

        public NotifyFutureCallback(NotifyQueueDO notifyQueue) {
            this.notifyQueue = notifyQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(HttpResponse response) {
            String body = null;
            String rulePattern = "([:]|\\b)[\"|\\s]{0,1}(OK|ok|true)[\"]{0,1}";
            NotifyTypeEnum notify = NotifyTypeEnum.getByCode((Integer)this.notifyQueue.getNotifyType());
            try {
                Header header = response.getEntity().getContentEncoding();
                String entity = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity()), (String)"utf-8") : EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                body = this.convertBody4Dcustom(entity);
                if (body != null) {
                    body = body.trim();
                }
                if (StringUtils.isBlank((String)body)) {
                    this.fail();
                    return;
                }
                if (body.length() > 500) {
                    body = body.substring(0, 500);
                    this.fail();
                    return;
                }
                Pattern pattern = Pattern.compile(rulePattern);
                Matcher matcher = pattern.matcher(body);
                if (matcher.find()) {
                    this.success();
                } else {
                    log.info("[appId {}] [type failed] [notifyType = {}] [body= {}]", new Object[]{this.notifyQueue.getAppId(), notify.getDescription(), body});
                    this.fail();
                }
            }
            catch (Exception e) {
                log.error("completed", (Throwable)e);
                this.fail();
            }
            finally {
                HttpRequestLog.logUrl("[action notify] [notifyType = " + notify.getDescription() + "] [tag response] [bizId " + this.notifyQueue.getDuibaOrderNum() + "] [type completed] [body " + body + "]");
            }
        }

        public void failed(Exception ex) {
            NotifyTypeEnum notify = NotifyTypeEnum.getByCode((Integer)this.notifyQueue.getNotifyType());
            HttpRequestLog.logUrl("[action notify] [notifyType = " + notify.getDescription() + "] [tag response] [bizId " + this.notifyQueue.getDuibaOrderNum() + "] [type failed] [ex " + ex.getMessage() + "]");
            this.fail();
        }

        public void cancelled() {
            NotifyTypeEnum notify = NotifyTypeEnum.getByCode((Integer)this.notifyQueue.getNotifyType());
            HttpRequestLog.logUrl("[action notify] [notifyType = " + notify.getDescription() + "] [tag response] [type cancelled] [bizId " + this.notifyQueue.getDuibaOrderNum() + "]");
            this.fail();
        }

        protected void success() {
            NotifyServiceImpl.this.notifyQueueDAO.finish(this.notifyQueue.getId());
        }

        protected void fail() {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(5, -1);
            if (this.notifyQueue.getTimes() > 6) {
                NotifyServiceImpl.this.notifyQueueDAO.finish(this.notifyQueue.getId());
                log.info("appId: {},relationType={},relationId={}, notify:{} fail,drop", new Object[]{this.notifyQueue.getAppId(), this.notifyQueue.getRelationType(), this.notifyQueue.getRelationId(), this.notifyQueue.getTimes()});
            } else if (this.notifyQueue.getTimes() > 1 && this.notifyQueue.getGmtCreate().before(cal.getTime())) {
                NotifyServiceImpl.this.notifyQueueDAO.finish(this.notifyQueue.getId());
                log.info("appId: {},relationType={},relationId={} notify > 24h,drop", new Object[]{this.notifyQueue.getAppId(), this.notifyQueue.getRelationType(), this.notifyQueue.getRelationId()});
            } else {
                Date nexttime = NotifyServiceImpl.this.getNextTime(this.notifyQueue);
                NotifyServiceImpl.this.notifyQueueDAO.updateNextTime(this.notifyQueue.getId(), this.notifyQueue.getTimes() + 1, nexttime);
            }
        }

        protected String convertBody4Dcustom(String entity) {
            return entity;
        }
    }
}

