/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.credits.SubVirtualCurrencyToDeveloper;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.RemoteVirtualCurrencyService;
import cn.com.duiba.thirdparty.dto.VirtualCurrencyMessage;
import cn.com.duiba.tool.CodeException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteVirtualCurrencyServiceImpl
implements RemoteVirtualCurrencyService {
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private SubVirtualCurrencyToDeveloper subVirtualCurrencyToDeveloper;

    public void submitSubVirtualCurrency(VirtualCurrencyMessage request, String callbackTopic, String msgTag, String msgKey) {
        this.validate(request, callbackTopic);
        this.subVirtualCurrencyToDeveloper.submit(request, callbackTopic, msgTag, msgKey);
    }

    private void validate(VirtualCurrencyMessage request, String callbackTopic) throws CodeException {
        if (StringUtils.isEmpty((String)callbackTopic)) {
            throw new CodeException("0", "\u8ba2\u9605Topic\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)request.getHttpUrl())) {
            throw new CodeException("0", "\u8bf7\u6c42URL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getAppId() == null) {
            throw new CodeException("0", "APPID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.httpAsyncClientPool.canSubmitToAppPool(request.getAppId())) {
            throw new CodeException("0", "\u5f00\u53d1\u8005\u63a5\u53e3\u7e41\u5fd9, appId: " + request.getAppId());
        }
    }
}

