/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.service.impl.CreditsLogExtractor;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCreditsLogExtractor
implements CreditsLogExtractor {
    private static final Logger log = LoggerFactory.getLogger(AbstractCreditsLogExtractor.class);

    AbstractCreditsLogExtractor() {
    }

    @Override
    public boolean supports(CreditsRequest request, CreditsResponse response) {
        return this.supportsInternal(request, response);
    }

    @Override
    public ConsumerCreditsLogSaveDto extract(CreditsRequest request, CreditsResponse response) {
        ConsumerCreditsLogSaveDto creditsLog = this.extractInternal(request, response);
        Map<String, String> params = this.extractRequestParams(request);
        if (MapUtils.isEmpty(params)) {
            log.info("\u79ef\u5206\u8bb0\u5f55\u83b7\u53d6params\u4e3anull, request={}", (Object)JSON.toJSONString((Object)request));
            return null;
        }
        creditsLog.setOrderNum(params.get("orderNum"));
        creditsLog.setBizType(params.get("type"));
        if (params.get("credits") == null) {
            log.info("\u79ef\u5206\u8bb0\u5f55\u83b7\u53d6credits\u4e3anull, request={}", (Object)JSON.toJSONString((Object)request));
            return null;
        }
        creditsLog.setCredits(Long.valueOf(Long.parseLong(params.get("credits"))));
        creditsLog.setDescription(params.get("description"));
        return creditsLog;
    }

    protected abstract boolean supportsInternal(CreditsRequest var1, CreditsResponse var2);

    protected abstract Map<String, String> extractRequestParams(CreditsRequest var1);

    protected abstract ConsumerCreditsLogSaveDto extractInternal(CreditsRequest var1, CreditsResponse var2);
}

