/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.biz.credits.CainiaoApi;
import cn.com.duiba.biz.credits.EzrApiService;
import cn.com.duiba.biz.credits.FengJinApi;
import cn.com.duiba.biz.credits.HaidilaoApi;
import cn.com.duiba.biz.credits.IqiyiApi;
import cn.com.duiba.biz.credits.MobikeApi;
import cn.com.duiba.biz.credits.MogujieApi;
import cn.com.duiba.biz.credits.PajkApi;
import cn.com.duiba.biz.credits.SohuzixunApi;
import cn.com.duiba.biz.credits.TaojinbiApi;
import cn.com.duiba.biz.credits.TaopiaopiaoApi;
import cn.com.duiba.biz.credits.WatsonsApi;
import cn.com.duiba.biz.credits.WeiboApi;
import cn.com.duiba.biz.credits.YoukuApi;
import cn.com.duiba.biz.virtual.AliTripApi;
import cn.com.duiba.constant.WatsonsConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomServiceImpl
implements CustomService {
    private static Logger log = LoggerFactory.getLogger(CustomServiceImpl.class);
    private static final List<Long> NOTIFY_WITH_TRANSFER = Arrays.asList(24202L, 27068L, 38854L, 1L);
    private static final List<Long> pajkAppIds = Arrays.asList(27271L, 30703L, 31294L);
    private static final List<Long> mobikeIds = Arrays.asList(33888L, 28651L, 35830L);
    private static final List<Long> iqiyiIds = Arrays.asList(31819L, 33713L, 37066L, 38347L);
    private static final List<Long> alisportsIds = Arrays.asList(21394L, 36558L);
    private static final List<Long> youkuIds = Arrays.asList(45031L, 46112L, 46113L);
    private static final List<Long> taopiaopiaoIds = Arrays.asList(47077L, 47074L);
    private static final List<Long> haidilaoIds = Arrays.asList(47663L, 48685L);
    private static final List<Long> weiboAppIds = Arrays.asList(49006L);
    private static final List<Long> usePostAppIds = Arrays.asList(49006L);
    @Autowired
    private WatsonsConfig watsonsConfig;
    @Value(value="${mogujie.appId}")
    private Long mogujieAppId;
    @Value(value="${taojinbi.appId}")
    private Long taojinbiAppId;
    @Value(value="${fengjin.appId}")
    private String fengJinAppId;
    @Autowired
    private MogujieApi mogujieApi;
    @Autowired
    private PajkApi pajkApi;
    @Autowired
    private TaojinbiApi taojinbiApi;
    @Autowired
    private MobikeApi mobikeApi;
    @Autowired
    private FengJinApi fengJinApi;
    @Autowired
    private IqiyiApi iqiyiApi;
    @Autowired
    private CainiaoApi cainiaoApi;
    @Autowired
    private AliTripApi aliTripApi;
    @Autowired
    private YoukuApi youkuApi;
    @Autowired
    private TaopiaopiaoApi taopiaopiaoApi;
    @Autowired
    private HaidilaoApi haidilaoApi;
    @Autowired
    private WeiboApi weiboApi;
    @Autowired
    private SohuzixunApi sohuzixunApi;
    @Autowired
    private EzrApiService ezrApiService;
    @Autowired
    private WatsonsApi watsonsApi;

    @Override
    public boolean isFengJin(Long appId) {
        return this.fengJinAppId != null && Arrays.asList(this.fengJinAppId.replace(" ", "").split(",")).contains(appId + "");
    }

    @Override
    public boolean isMogujie(Long appId) {
        return this.mogujieAppId != null && this.mogujieAppId.equals(appId);
    }

    @Override
    public boolean isCainiao(Long appId) {
        return CainiaoApi.isCainiao(appId);
    }

    @Override
    public boolean isAliTrip(Long appId) {
        return AliTripApi.isAliTrip(appId);
    }

    @Override
    public boolean isPajk(Long appId) {
        return appId != null && pajkAppIds.contains(appId);
    }

    @Override
    public boolean isTaojinbi(Long appId) {
        return this.taojinbiAppId != null && this.taojinbiAppId.equals(appId);
    }

    @Override
    public boolean isMobike(Long appId) {
        return mobikeIds.contains(appId);
    }

    @Override
    public boolean isIqiyi(Long appId) {
        return appId != null && iqiyiIds.contains(appId);
    }

    @Override
    public boolean isYouku(Long appId) {
        return appId != null && youkuIds.contains(appId);
    }

    @Override
    public boolean isTaopiaopiao(Long appId) {
        return appId != null && taopiaopiaoIds.contains(appId);
    }

    @Override
    public boolean isAlisports(Long appId) {
        return appId != null && alisportsIds.contains(appId);
    }

    @Override
    public boolean isHaiDiLao(Long appId) {
        return appId != null && haidilaoIds.contains(appId);
    }

    @Override
    public boolean isWeibo(Long appId) {
        return appId != null && weiboAppIds.contains(appId);
    }

    @Override
    public boolean isWatsons(Long appId) {
        return appId != null && this.watsonsConfig.getWatsonsAppIdSet().contains(appId);
    }

    @Override
    public CreditsMessage getRequestCredits(CreditsMessage request) {
        if (request.getAppId() == null) {
            return request;
        }
        Long appId = Long.valueOf(request.getAppId());
        if (this.isMogujie(appId)) {
            return this.mogujieApi.getMogujieRequestCredits(request);
        }
        if (this.isPajk(appId)) {
            return this.pajkApi.getPajkRequestCredits(request);
        }
        if (this.isTaojinbi(appId)) {
            return this.taojinbiApi.getCreditsMessage(request);
        }
        if (this.isMobike(appId)) {
            return this.mobikeApi.buildSubCreditsRequest(request);
        }
        if (this.isFengJin(appId)) {
            return this.fengJinApi.getSubCreditsMessage(request);
        }
        if (this.isIqiyi(appId)) {
            return this.iqiyiApi.getSubCreditsMessage(request);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return this.cainiaoApi.getRequestCredits(request);
        }
        if (this.isYouku(appId)) {
            return this.youkuApi.getSubCreditsMessage(request);
        }
        if (this.isTaopiaopiao(appId)) {
            return this.taopiaopiaoApi.getSubCreditsMessage(request);
        }
        if (this.isHaiDiLao(appId)) {
            return this.haidilaoApi.getSubCreditsMessage(request);
        }
        if (this.isWeibo(appId)) {
            return this.weiboApi.getSubCreditsMessage(request);
        }
        return request;
    }

    @Override
    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        if (subCreditsMsgWrapper.getSubCreditsMsg().getAppId() == null) {
            return subCreditsMsgWrapper;
        }
        Long appId = (long)subCreditsMsgWrapper.getSubCreditsMsg().getAppId();
        if (this.isMogujie(appId)) {
            return this.mogujieApi.getMogujieRequestCredits(subCreditsMsgWrapper);
        }
        if (this.isPajk(appId)) {
            return this.pajkApi.getPajkRequestCredits(subCreditsMsgWrapper);
        }
        if (this.isTaojinbi(appId)) {
            return this.taojinbiApi.getCreditsMessage(subCreditsMsgWrapper);
        }
        if (this.isMobike(appId)) {
            return this.mobikeApi.buildSubCreditsRequest(subCreditsMsgWrapper);
        }
        if (this.isFengJin(appId)) {
            return this.fengJinApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (this.isIqiyi(appId)) {
            return this.iqiyiApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return this.cainiaoApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if (this.isYouku(appId)) {
            return this.youkuApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if (this.isHaiDiLao(appId)) {
            return this.haidilaoApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if (this.isWeibo(appId)) {
            return this.weiboApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if (this.ezrApiService.isEzr(appId).booleanValue()) {
            return this.ezrApiService.getRequestCredits(subCreditsMsgWrapper);
        }
        return subCreditsMsgWrapper;
    }

    @Override
    public String getResponseCredits(Long appId, String body) {
        if (appId == null) {
            return body;
        }
        HttpRequestLog.logUrl("[action subCredits] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
        if (this.isMogujie(appId)) {
            return this.mogujieApi.getMogujieResponseCredis(body);
        }
        if (this.isPajk(appId)) {
            return this.pajkApi.getPajkResponseCredits(appId, body);
        }
        if (this.isTaojinbi(appId)) {
            return this.taojinbiApi.parseCreditsRsp(body);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return this.cainiaoApi.parseCreditsRsp(body);
        }
        if (this.isYouku(appId)) {
            return this.youkuApi.parseCreditsRsp(body);
        }
        if (this.isTaopiaopiao(appId)) {
            return this.taopiaopiaoApi.parseCreditsRsp(body);
        }
        if (this.ezrApiService.isEzr(appId).booleanValue()) {
            return this.ezrApiService.parseCreditsRsp(body);
        }
        return body;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, String time, AppDO appDO, CreditNotifyParams params) {
        try {
            if (this.isMogujie(record.getAppId())) {
                return this.mogujieApi.getMogujieRequestNotify(notifyUrl, record);
            }
            if (this.isPajk(record.getAppId())) {
                return this.pajkApi.getPajkRequestNotify(notifyUrl, record);
            }
            if (this.isMobike(record.getAppId())) {
                return MobikeApi.getMobikeNotifyUrl(notifyUrl, record, time);
            }
            if (this.isFengJin(record.getAppId())) {
                return this.fengJinApi.getRequestNotify(notifyUrl, record, appDO);
            }
            if (this.isIqiyi(record.getAppId())) {
                return this.iqiyiApi.getRequestNotify(notifyUrl, record);
            }
            if (this.isCainiao(record.getAppId())) {
                return this.cainiaoApi.getRequestNotify(notifyUrl, record, appDO, params);
            }
            if (this.isYouku(record.getAppId())) {
                return this.youkuApi.getRequestNotify(notifyUrl, record);
            }
            if (this.isHaiDiLao(record.getAppId())) {
                return this.haidilaoApi.getRequestNotify(notifyUrl, record, appDO, params);
            }
            if (this.ezrApiService.isEzr(record.getAppId()).booleanValue()) {
                return this.ezrApiService.getRequestNotify(notifyUrl, record, appDO);
            }
            return null;
        }
        catch (Exception e) {
            log.error("getRequestNotify", (Object)e.getMessage());
            throw new IllegalStateException("notify error", e);
        }
    }

    @Override
    public String getResponseNotify(Long appId, String body) {
        try {
            if (this.isMogujie(appId)) {
                HttpRequestLog.logUrl("[action notify] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
                return this.mogujieApi.getMogujieResponseNotify(body);
            }
            if (this.isPajk(appId)) {
                HttpRequestLog.logUrl("[action notify] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
                return this.pajkApi.getPajkResponseNotify(body);
            }
        }
        catch (Exception e) {
            log.error("getResponseNotify", (Throwable)e);
        }
        return body;
    }

    @Override
    public boolean isNotifyWithTransfer(Long appId) {
        return NOTIFY_WITH_TRANSFER.contains(appId);
    }

    @Override
    public Map<String, String> toRequestMapWithTransfer(String appSecret, CreditNotifyParams p, String transfer, String uid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("success", Boolean.toString(p.isSuccess()));
        map.put("errorMessage", this.getString(p.getErrorMessage()));
        map.put("bizId", this.getString(p.getBizId()));
        map.put("appKey", this.getString(p.getAppKey()));
        map.put("appSecret", this.getString(appSecret));
        map.put("timestamp", this.getString(p.getTimestamp().getTime()));
        map.put("uid", this.getString(uid));
        map.put("orderNum", this.getString(p.getOrderNum()));
        map.put("transfer", this.getString(transfer));
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }

    @Override
    public SupplierRequest getVirturalRequest(SupplierRequest request) {
        if (request.getAppId() == null) {
            return request;
        }
        Long appId = Long.valueOf(request.getAppId());
        if (this.isMogujie(appId)) {
            return this.mogujieApi.getMogujieRequestSendCredits(request);
        }
        if (this.isMobike(appId)) {
            return MobikeApi.getVirtualRequest(request);
        }
        if (this.isIqiyi(appId)) {
            return this.iqiyiApi.getVirtualRequest(request);
        }
        if (this.isAliTrip(appId)) {
            return this.aliTripApi.getVirtualRequest(request);
        }
        if (this.isHaiDiLao(appId)) {
            return this.haidilaoApi.getVirtualRequest(request);
        }
        if (this.isYouku(appId)) {
            return this.youkuApi.getVirtualRequest(request);
        }
        if (this.isWeibo(appId)) {
            return this.weiboApi.getVirtualRequest(request);
        }
        if (this.isWatsons(appId)) {
            return this.watsonsApi.getVirtualRequest(request);
        }
        return request;
    }

    @Override
    public String getVirturalResponse(SupplierRequest message, String body) {
        if (message.getAppId() == null) {
            return body;
        }
        Long appId = Long.valueOf(message.getAppId());
        if (this.isMogujie(appId)) {
            return this.mogujieApi.getVirtualRespone(body);
        }
        if (this.isIqiyi(appId)) {
            return this.iqiyiApi.getVirtualRespone(body);
        }
        if (this.isAliTrip(appId)) {
            return this.aliTripApi.getVirtualRespone(body);
        }
        if (this.isHaiDiLao(appId)) {
            return this.haidilaoApi.getVirtualRespone(message, body);
        }
        if (this.isYouku(appId)) {
            return this.youkuApi.getVirtualRespone(body);
        }
        if (this.isWatsons(appId)) {
            return this.watsonsApi.getVirtualRespone(body);
        }
        return body;
    }

    @Override
    public HttpRequestBase getCrecordHttpRequest(HttpRequestMessageDto msg, AppDO app) {
        if (app != null && this.isCainiao(app.getId())) {
            return this.cainiaoApi.getCrecordNotify(msg, app);
        }
        return null;
    }

    @Override
    public CreditsMessageDto getRequestAddCredits(CreditsMessageDto request) {
        if (request.getAppId() == null) {
            return request;
        }
        Long appId = Long.valueOf(request.getAppId());
        if (this.isTaopiaopiao(appId)) {
            return this.taopiaopiaoApi.getAddCreditsMessage(request);
        }
        if (this.isPajk(appId)) {
            return this.pajkApi.getAddCreditsMessage(request);
        }
        if (this.isHaiDiLao(appId)) {
            return this.haidilaoApi.getAddCreditsMessage(request);
        }
        if (this.isWeibo(appId)) {
            return this.weiboApi.getAddCreditsMessage(request);
        }
        if (this.ezrApiService.isEzr(appId).booleanValue()) {
            return this.ezrApiService.getAddCreditsMessage(request);
        }
        return request;
    }

    @Override
    public void setHaidilaoSubAndAddHttpHeader(CreditsMessage request, HttpRequestBase http) {
        this.haidilaoApi.setHttpHeader(request, http, true);
    }

    @Override
    public HttpRequestBase setHaidilaoVirtualHttpHeader(SupplierRequest message, HttpRequestBase http) {
        return this.haidilaoApi.setHaidilaoVirtualHttpHeader(message, http);
    }

    @Override
    public boolean isPostApp(Long appId) {
        return null != appId && usePostAppIds.contains(appId);
    }
}

